/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardDockAction
implements StandardDockAction {
    protected List<StandardDockActionListener> listeners = new ArrayList<StandardDockActionListener>();
    private Map<Dockable, Integer> bound = new HashMap<Dockable, Integer>();

    @Override
    public void addDockActionListener(StandardDockActionListener standardDockActionListener) {
        this.listeners.add(standardDockActionListener);
    }

    @Override
    public void removeDockActionListener(StandardDockActionListener standardDockActionListener) {
        this.listeners.remove(standardDockActionListener);
    }

    protected void bound(Dockable dockable) {
    }

    protected void unbound(Dockable dockable) {
    }

    public boolean isBound(Dockable dockable) {
        return this.bound.containsKey(dockable);
    }

    public Set<Dockable> getBoundDockables() {
        return Collections.unmodifiableSet(this.bound.keySet());
    }

    @Override
    public void bind(Dockable dockable) {
        Integer n = this.bound.get(dockable);
        if (n == null) {
            this.bound.put(dockable, 1);
            this.bound(dockable);
        } else {
            this.bound.put(dockable, n + 1);
        }
    }

    @Override
    public void unbind(Dockable dockable) {
        Integer n = this.bound.get(dockable);
        if (n == null) {
            try {
                throw new NullPointerException("Unbind called too often, omit unbind and continue");
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        } else if (n == 1) {
            this.bound.remove(dockable);
            this.unbound(dockable);
        } else {
            this.bound.put(dockable, n - 1);
        }
    }

    protected void fireActionTextChanged(Set<Dockable> set) {
        for (StandardDockActionListener standardDockActionListener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            standardDockActionListener.actionTextChanged(this, set);
        }
    }

    protected void fireActionTooltipTextChanged(Set<Dockable> set) {
        for (StandardDockActionListener standardDockActionListener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            standardDockActionListener.actionTooltipTextChanged(this, set);
        }
    }

    protected void fireActionIconChanged(Set<Dockable> set) {
        for (StandardDockActionListener standardDockActionListener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            standardDockActionListener.actionIconChanged(this, set);
        }
    }

    protected void fireActionDisabledIconChanged(Set<Dockable> set) {
        for (StandardDockActionListener standardDockActionListener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            standardDockActionListener.actionDisabledIconChanged(this, set);
        }
    }

    protected void fireActionEnabledChanged(Set<Dockable> set) {
        for (StandardDockActionListener standardDockActionListener : this.listeners.toArray(new StandardDockActionListener[this.listeners.size()])) {
            standardDockActionListener.actionEnabledChanged(this, set);
        }
    }
}

