/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.AbstractBubbleDockTitle;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Condition;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Point;

public class BubbleButtonDockTitle
extends AbstractBubbleDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        public void install(DockTitleRequest dockTitleRequest) {
        }

        public void uninstall(DockTitleRequest dockTitleRequest) {
        }

        public void request(DockTitleRequest dockTitleRequest) {
            dockTitleRequest.answer(new BubbleButtonDockTitle(dockTitleRequest.getTarget(), dockTitleRequest.getVersion()));
        }
    };
    private FlapDockStation.ButtonContent behavior;
    private boolean selected = false;

    public BubbleButtonDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        this.behavior = FlapDockStation.ButtonContent.THEME_DEPENDENT;
        if (dockTitleVersion != null) {
            this.behavior = dockTitleVersion.getController().getProperties().get(FlapDockStation.BUTTON_CONTENT);
        }
        this.init(dockable, dockTitleVersion, this.behavior.showActions(false));
    }

    protected BubbleButtonDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion dockTitleVersion, boolean bl) {
        super.init(dockable, dockTitleVersion, bl);
        this.initAnimation();
        this.updateAnimation();
        this.updateFonts();
    }

    private void initAnimation() {
        Path path = TitleColor.KIND_FLAP_BUTTON_COLOR;
        this.addColor("title.background.top.active.mouse.flap", path, Color.RED);
        this.addColor("title.background.top.active.flap", path, Color.LIGHT_GRAY);
        this.addColor("title.background.top.inactive.mouse.flap", path, Color.BLUE);
        this.addColor("title.background.top.inactive.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.top.selected.mouse.flap", path, Color.BLUE);
        this.addColor("title.background.top.selected.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.active.mouse.flap", path, Color.LIGHT_GRAY);
        this.addColor("title.background.bottom.active.flap", path, Color.WHITE);
        this.addColor("title.background.bottom.inactive.mouse.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.inactive.flap", path, Color.BLACK);
        this.addColor("title.background.bottom.selected.mouse.flap", path, Color.DARK_GRAY);
        this.addColor("title.background.bottom.selected.flap", path, Color.BLACK);
        this.addColor("title.foreground.active.mouse.flap", path, Color.BLACK);
        this.addColor("title.foreground.active.flap", path, Color.BLACK);
        this.addColor("title.foreground.inactive.mouse.flap", path, Color.WHITE);
        this.addColor("title.foreground.inactive.flap", path, Color.WHITE);
        this.addColor("title.foreground.selected.mouse.flap", path, Color.WHITE);
        this.addColor("title.foreground.selected.flap", path, Color.WHITE);
        this.addConditionalFont("title.flap.active", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return BubbleButtonDockTitle.this.isActive();
            }
        }, null);
        this.addConditionalFont("title.flap.selected", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return BubbleButtonDockTitle.this.isSelected();
            }
        }, null);
        this.addConditionalFont("title.flap.inactive", TitleFont.KIND_FLAP_BUTTON_FONT, new Condition(){

            public boolean getState() {
                return !BubbleButtonDockTitle.this.isActive();
            }
        }, null);
    }

    public void changed(DockTitleEvent dockTitleEvent) {
        this.selected = dockTitleEvent.isActive() || dockTitleEvent.isPreferred();
        super.setActive(dockTitleEvent.isActive());
        this.updateAnimation();
        this.updateFonts();
    }

    public void setActive(boolean bl) {
        if (bl != this.isActive()) {
            super.setActive(bl);
            this.selected = bl;
            this.updateAnimation();
            this.updateFonts();
        }
    }

    protected void updateAnimation() {
        String string = "";
        string = this.isActive() ? (this.isMouseOver() ? "active.mouse" : "active") : (this.isSelected() ? (this.isMouseOver() ? "selected.mouse" : "selected") : (this.isMouseOver() ? "inactive.mouse" : "inactive"));
        String string2 = "title.background.top." + string + ".flap";
        String string3 = "title.background.bottom." + string + ".flap";
        String string4 = "title.foreground." + string + ".flap";
        this.updateAnimation("text", string4);
        this.updateAnimation("top", string2);
        this.updateAnimation("top", string3);
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void updateIcon() {
        String string = this.getDockable().getTitleText();
        if (this.behavior.showIcon(string != null && string.length() > 0, true)) {
            super.updateIcon();
        } else {
            this.setIcon(null);
        }
    }

    protected void updateText() {
        if (this.behavior.showText(this.getDockable().getTitleIcon() != null, true)) {
            super.updateText();
        } else {
            this.setText("");
        }
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        switch (orientation) {
            case SOUTH_SIDED: 
            case NORTH_SIDED: 
            case FREE_HORIZONTAL: {
                orientation = DockTitle.Orientation.FREE_HORIZONTAL;
                break;
            }
            case EAST_SIDED: 
            case WEST_SIDED: 
            case FREE_VERTICAL: {
                orientation = DockTitle.Orientation.FREE_VERTICAL;
            }
        }
        super.setOrientation(orientation);
    }
}

