% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\docType{methods}
\name{splice}
\alias{splice}
\alias{splice,Spectra-method}
\title{Splice correction of a spectra collected using ASD hardware}
\usage{
\S4method{splice}{Spectra}(x, locations = list(c(750, 1000), c(1830, 1950)))
}
\arguments{
\item{x}{a \code{Spectra} object}

\item{locations}{the wavelengths to cut out and interpolate}
}
\value{
an object of same class as x
}
\description{
This is the correction method available in the ViewSpec Pro
software from ASD, which aims at correcting steps in the data (see details).
}
\details{
The SWIR1 part of the spectrum (1000-1800 nm) is taken as a reference 
for corrections as it is stable to the instrument sensitivity drift (Beal & Eamon, 2010)

This is based on a description of the splice correction algorithm available on
the ASD website at \url{http://support.asdi.com/Document/Documents.aspx}.
}
\examples{

data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500
oz_spliced <- splice(australia)
plot(oz_spliced)

}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
