% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_head.R
\name{big.head}
\alias{big.head}
\alias{big.tail}
\title{Return the First or Last Part of an Object}
\usage{
big.head(x, n = 5, l = 5, r = 5)
}
\arguments{
\item{x}{a \code{"data.frame"} or a \code{"matrix"} object}

\item{n}{a single, positive integer, number of rows for the object to return}

\item{l}{a single, positive integer, the number of columns to include on the left}

\item{r}{a single, positive integer, the number of columns to include on the right}
}
\value{
An object (usually) like 'x' but generally smaller.
}
\description{
Return the First or Last Part of an Object
}
\details{
Returns the first or last rows of a data frame like head() and tail(), but
also only returns the first and last columns. This has been implemented to
check big data frames.
}
\examples{

big.head(mtcars)
big.tail(mtcars)
big.tail(mtcars, 10)
big.head(mtcars, 10, 2, 4)
big.head(mtcars, , , 1)

data(australia)
big.head(australia)

}
\seealso{
\code{\link{head}}, \code{\link{tail}}
}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
