% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotDeviance}
\alias{plotDeviance}
\title{Plots the deviance of residuals across model specifications.}
\usage{
plotDeviance(sca_data, title = "", showIndex = TRUE, plotVars = TRUE)
}
\arguments{
\item{sca_data}{A data frame returned by `sca()` containing model estimates
from the specification curve analysis.}

\item{title}{A string to use as the plot title. Defaults to an empty string,
`""`.}

\item{showIndex}{A boolean indicating whether to label the model index on the
the x-axis. Defaults to `TRUE`.}

\item{plotVars}{A boolean indicating whether to include a panel on the plot
showing which variables are present in each model. Defaults
to `TRUE`.}
}
\value{
If `plotVars = TRUE` returns a grid grob (i.e. the output of a call
        to `grid.draw`). If `plotVars =  FALSE` returns a ggplot object.
}
\description{
plotDeviance() plots the deviance of residuals across model specifications.
Only available for linear regression models.
}
\examples{
plotDeviance(sca_data = sca(y = "Salnty", x = "T_degC",
                            controls = c("ChlorA", "O2Sat"),
                            data = bottles, progressBar = TRUE,
                            parallel = FALSE),
                     title = "Model Deviance");
plotDeviance(sca_data = sca(y = "Salnty", x = "T_degC",
                            controls = c("ChlorA*O2Sat"),
                            data = bottles, progressBar = FALSE,
                            parallel = FALSE),
                     showIndex = FALSE, plotVars = FALSE);
plotDeviance(sca_data = sca(y = "Salnty", x="T_degC",
                         controls = c("ChlorA*NO3uM", "O2Sat*NO3uM"),
                         data = bottles, progressBar = TRUE, parallel = TRUE,
                         workers = 2));
}
