% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency-criteria.R
\name{calculate_efficiency_criteria}
\alias{calculate_efficiency_criteria}
\title{Calculate efficiency criteria}
\usage{
calculate_efficiency_criteria(
  design_vcov,
  p = NULL,
  dudx = NULL,
  return_all = FALSE,
  significance = 1.96,
  type
)
}
\arguments{
\item{design_vcov}{A variance-covariance matrix returned by
\code{\link{derive_vcov}} or returned by an estimation routine. The matrix
should be symmetrical and K-by-K}

\item{p}{Prior values}

\item{dudx}{A character string giving the name of the parameter in the
denominator. Must be specified when optimizing for 'c-error'}

\item{return_all}{If `TRUE` return a K or K-1 vector with parameter specific error
measures. Default is `FALSE`.}

\item{significance}{A t-value corresponding to the desired level of
significance. The default is significance at the 5% level with an associated
t-value of 1.96.}

\item{type}{A string indicating the type of efficiency criteria to calculate
can be either: "a-error", "c-error", "d-error" or "s-error"}
}
\value{
See individual efficiency criteria
}
\description{
The function is a wrapper around \code{\link{calculate_a_error}},
\code{\link{calculate_c_error}}, \code{\link{calculate_d_error}} and
\code{\link{calculate_s_error}} to provide a unified interface for
calling and calculating efficiency criteria.
}
\details{
The function is mainly used internally to evaluate and report on designs,
but is exported to allow the user to use the function to calculate the
efficiency criteria of the model once it has been run on their data.
}
\references{
Bliemer and Rose, 2009, Efficiency and sample size requirements for state
choice experiments, Transportation Research Board Annual Meeting, Washington
DC
Scarpa and Rose, 2008, Designs efficiency for non-market valuation with
choice modelling: How to measure it, what to report and why, Australian
Journal of Agricultural and Resource Economics, 52(3):253-282
Bliemer and Rose, 2005a, Efficiency and sample size requirements for stated
choice experiments, Report ITLS-WP-05-08, Institute for Transport and
Logistics Studies, University of Sydney
Kessels, R., Goos, P. and Vandebroek, M., 2006, A comparison of criteria to
design efficient choice experiments, Journal of Marketing Research,
43(3):409-419
}
