\name{wheat}
\alias{wheat}
\docType{data}
\title{Mercer and Hall wheat yield data}
\description{
  Mercer and Hall wheat yield data, based on version in Cressie (1993), p. 455.
}
\usage{data(wheat)}
\format{
  The format of the object generated by running \code{data(wheat)} is a three column data frame made available by Hongfei Li. The example section shows how to convert this to the object used in demonstrating the \code{aple} function, and is a:
Formal class 'SpatialPolygonsDataFrame' [package "sp"] with 5 slots;
  the data slot is a data frame with 500 observations on the following 6 variables.
  \describe{
    \item{\code{lat}}{local coordinates northings ordered north to south}
    \item{\code{yield}}{Mercer and Hall wheat yield data}
    \item{\code{r}}{rows south to north; levels in distance units of plot centres}
    \item{\code{c}}{columns west to east; levels in distance units of plot centres}
    \item{\code{lon}}{local coordinates eastings}
    \item{\code{lat1}}{local coordinates northings ordered south to north}
}}
\source{
  Cressie, N. A. C. (1993) Statistics for Spatial Data. Wiley, New York, p. 455.
}
\references{
  Mercer, W. B. and Hall, A. D. (1911) The experimental error of field trials. Journal of Agricultural Science 4, 107-132.
}
\examples{
\dontrun{
data(wheat)
names(wheat) <- c('lon','lat','yield')
wheat$lat1 <- 69 - wheat$lat
wheat$r <- factor(wheat$lat1)
wheat$c <- factor(wheat$lon)
wheat_sp <- wheat
coordinates(wheat_sp) <- c("lon", "lat1")
wheat_spg <- wheat_sp
gridded(wheat_spg) <- TRUE
wheat_spl <- as(wheat_spg, "SpatialPolygons")
df <- as(wheat_spg, "data.frame")
row.names(df) <- sapply(slot(wheat_spl, "polygons"),
 function(x) slot(x, "ID"))
wheat <- SpatialPolygonsDataFrame(wheat_spl, data=df)
}
wheat <- readShapeSpatial(system.file("etc/shapes/wheat.shp",
 package="spdep")[1])
}
\keyword{datasets}
