% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatsurvMisc.R
\name{inference.control}
\alias{inference.control}
\title{inference.control function}
\usage{
inference.control(gridded = FALSE, cellwidth = NULL, ext = 2,
  imputation = NULL, optimcontrol = NULL, hessian = FALSE,
  plotcal = FALSE, timeonlyMCMC = FALSE, nugget = FALSE,
  savenugget = FALSE, split = 0.5, logUsigma_priormean = 0,
  logUsigma_priorsd = 0.5, nis = NULL, olinfo = NULL)
}
\arguments{
\item{gridded}{logical. Whether to perform compuation on a grid. Default is FALSE.}

\item{cellwidth}{the width of computational cells to use}

\item{ext}{integer the number of times to extend the computational grid by in order to perform compuitation. The default is 2.}

\item{imputation}{for polygonal data, an optional model for inference at the sub-polygonal level, see function imputationModel}

\item{optimcontrol}{a list of optional arguments to be passed to optim for non-spatial models}

\item{hessian}{whether to return a numerical hessian. Set this to TRUE for non-spatial models.
equal to the number of parameters of the baseline hazard}

\item{plotcal}{logical, whether to produce plots of the MCMC calibration process, this is a technical option and should onyl be set
to TRUE if poor mixing is evident (the printed h is low), then it is also useful to use a graphics device with multiple plotting windows.}

\item{timeonlyMCMC}{logical, whether to only time the MCMC part of the algorithm, or whether to include in the reported running time the time taken to calibrate the method (default)}

\item{nugget}{whether to include a nugget effect in the estimation. Note that only the mean and variance of the nugget effect is returned.}

\item{savenugget}{whether to save the MCMC chain for the nugget effect}

\item{split}{how to split the spatial and nugget proposal variance as a the proportion of variance assigned to the spatial effect apriori. Default is 0.5}

\item{logUsigma_priormean}{prior mean for log standard deviation of nugget effect}

\item{logUsigma_priorsd}{prior sd for log standard deviation of nugget effect}

\item{nis}{list of cell counts, each element being a matrix, with attributes "x" and "y" giving grid centroids in x and y directions. Used to impute locations of aggregated data:.}

\item{olinfo}{to be supplied with nis, if continuous inference from aggregated data is required}
}
\value{
returns parameters to be used in the function survspat
}
\description{
A function to control inferential settings. This function is used to set parameters for more advanced use of spatsurv.
}
\seealso{
\link{survspat}
}

