% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_variogram_indic.R,
%   R/task_variogram_indic_indictest.R
\name{variogram_sews_plot}
\alias{variogram_sews_plot}
\alias{plot.variogram_sews}
\alias{plot_variogram}
\alias{plot_variogram.variogram_sews}
\alias{plot.variogram_sews_test}
\alias{plot_variogram.variogram_sews_test}
\title{Early-warning signals based on variograms}
\usage{
\method{plot}{variogram_sews}(x, along = NULL, ...)

plot_variogram(x, along = NULL, ...)

\method{plot_variogram}{variogram_sews}(x, along = NULL, ...)

\method{plot}{variogram_sews_test}(x, along = NULL, what = "value", display_null = TRUE, ...)

\method{plot_variogram}{variogram_sews_test}(x, along = NULL, what = "value", display_null = TRUE, ...)
}
\arguments{
\item{x}{An object produced by \code{\link{variogram_sews}}, or the 
result of applying \code{indictest} on such object.}

\item{along}{A vector providing values along which the indicator trends 
will be plotted. If \code{NULL} then the indicator values are plotted
sequentially in their original order.}

\item{...}{Other arguments are ignored.}

\item{what}{The trendline to be displayed. Defaults to the indicator's 
values ("value") but other metrics can be displayed. Accepted values are 
"value", "pval", "difference" (obs - null mean), or "z_score" 
( (obs - null mean) / (null sd) ).}

\item{display_null}{Chooses whether a grey ribbon should be added to reflect
the null distribution. Note that it can not be displayed when the trend 
line reflects something else than the indicator values (when \code{what} 
is not set to "value").}
}
\description{
Plot trends of indicators based on variograms
}
\details{
The \code{plot()} function will display how the estimated 
  variogram parameters change along a set of values (passed with argument
  \code{along}). If the object passed has been processed through 
  \code{indictest}, then the null values are also displayed. 
  \code{plot_variogram()} can be used to display the individual variograms
  that have been fit to the data.
}
\examples{
  
\donttest{ 
serengeti_ews <- variogram_sews(serengeti, model ="exp")

# Display the change in variogram parameters 
plot(serengeti_ews, along = serengeti.rain) + 
  ggplot2::labs(x = "Rainfall (mm)")

# Visualize the fitted variograms
plot_variogram(serengeti_ews, along = serengeti.rain) 

  # Test the trends (nulln should be set to a higher value to obtain 
  # meaningful results
  serengeti_test <- indictest(serengeti_ews, nulln = 19)
  plot(serengeti_test, along = serengeti.rain)
  plot_variogram(serengeti_test, along = serengeti.rain)
}

}
\seealso{
\code{\link{variogram_sews}}, \code{\link{indictest}}, 
  \code{\link{plot_variogram}}
}
