% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_spatial_predictors.R
\name{rank_spatial_predictors}
\alias{rank_spatial_predictors}
\title{Ranks spatial predictors}
\usage{
rank_spatial_predictors(
  data = NULL,
  dependent.variable.name = NULL,
  predictor.variable.names = NULL,
  distance.matrix = NULL,
  distance.thresholds = NULL,
  ranger.arguments = NULL,
  spatial.predictors.df = NULL,
  ranking.method = c("moran", "effect"),
  reference.moran.i = 1,
  verbose = FALSE,
  n.cores = parallel::detectCores() - 1,
  cluster = NULL
)
}
\arguments{
\item{data}{Data frame with a response variable and a set of predictors. Default: \code{NULL}}

\item{dependent.variable.name}{Character string with the name of the response variable. Must be in the column names of \code{data}. Default: \code{NULL}}

\item{predictor.variable.names}{Character vector with the names of the predictive variables. Every element of this vector must be in the column names of \code{data}. Default: \code{NULL}}

\item{distance.matrix}{Squared matrix with the distances among the records in \code{data}. The number of rows of \code{distance.matrix} and \code{data} must be the same. If not provided, the computation of the Moran's I of the residuals is omitted. Default: \code{NULL}}

\item{distance.thresholds}{Numeric vector with neighborhood distances. All distances in the distance matrix below each value in \code{dustance.thresholds} are set to 0 for the computation of Moran's I. If \code{NULL}, it defaults to seq(0, max(distance.matrix), length.out = 4). Default: \code{NULL}}

\item{ranger.arguments}{List with \link[ranger]{ranger} arguments. See \link{rf} or \link{rf_repeat} for further details.}

\item{spatial.predictors.df}{Data frame of spatial predictors.}

\item{ranking.method}{Character, method used by to rank spatial predictors. The method "effect" ranks spatial predictors according how much each predictor reduces Moran's I of the model residuals, while the method "moran" ranks them by their own Moran's I. Default: \code{"moran"}.}

\item{reference.moran.i}{Moran's I of the residuals of the model without spatial predictors. Default: \code{1}}

\item{verbose}{Logical, ff \code{TRUE}, messages and plots generated during the execution of the function are displayed, Default: \code{TRUE}}

\item{n.cores}{Integer, number of cores to use for parallel execution. Creates a socket cluster with \code{parallel::makeCluster()}, runs operations in parallel with \code{foreach} and \verb{\%dopar\%}, and stops the cluster with \code{parallel::clusterStop()} when the job is done. Default: \code{parallel::detectCores() - 1}}

\item{cluster}{A cluster definition generated with \code{parallel::makeCluster()}. If provided, overrides \code{n.cores}. When \code{cluster = NULL} (default value), and \code{model} is provided, the cluster in \code{model}, if any, is used instead. If this cluster is \code{NULL}, then the function uses \code{n.cores} instead. The function does not stop a provided cluster, so it should be stopped with \code{parallel::stopCluster()} afterwards. The cluster definition is stored in the output list under the name "cluster" so it can be passed to other functions via the \code{model} argument, or using the \verb{\%>\%} pipe. Default: \code{NULL}}
}
\value{
A list with four slots:
\itemize{
\item \code{method}: Character, name of the method used to rank the spatial predictors.
\item \code{criteria}: Data frame with two different configurations depending on the ranking method. If \code{ranking.method = "effect"}, the columns contain the names of the spatial predictors, the r-squared of the model, the Moran's I of the model residuals, the difference between the Moran's I of the model including the given spatial predictor, and the Moran's I of the model fitted without spatial predictors, and the interpretation of the Moran's I value. If \code{ranking.method = "moran"}, only the name of the spatial predictor and it's Moran's I are in the output data frame.
\item \code{ranking}: Ordered character vector with the names of the spatial predictors selected.
\item \code{spatial.predictors.df}: data frame with the selected spatial predictors in the order of the ranking.
}
}
\description{
Ranks spatial predictors generated by \code{\link[=mem_multithreshold]{mem_multithreshold()}} or \code{\link[=pca_multithreshold]{pca_multithreshold()}} by their effect in reducing the Moran's I of the model residuals (\code{ranking.method = "effect"}), or by their own Moran's I (\code{ranking.method = "moran"}).

In the former case, one model of the type \code{y ~ predictors + spatial_predictor_X} is fitted per spatial predictor, and the Moran's I of this model's residuals is compared with the one of the model without spatial predictors (\code{y ~ predictors}), to finally rank the spatial predictor from maximum to minimum difference in Moran's I.

In the latter case, the spatial predictors are ordered by their Moran's I alone (this is the faster option).

In both cases, spatial predictors that are redundant with others at a Pearson correlation > 0.5 and spatial predictors with no effect (no reduction of Moran's I  or Moran's I of the spatial predictor equal or lower than 0) are removed.

This function has been designed to be used internally by \code{\link[=rf_spatial]{rf_spatial()}} rather than directly by a user.
}
\examples{
if(interactive()){

 #loading distance matrix
 data(distance_matrix)

 #computing Moran's Eigenvector Maps
 mem.df <- mem(
  distance.matrix = distance_matrix[1:50, 1:50],
  distance.threshold = 0
 )

 #ranking by the Moran's I of the spatial predictor
 rank <- rank_spatial_predictors(
  distance.matrix = distance_matrix[1:50, 1:50],
  distance.thresholds = 0,
  spatial.predictors.df = mem.df,
  ranking.method = "moran",
  n.cores = 1
 )

 #checking Moran's I of MEMs
 rank$criteria

 #checking rank of MEMs
 rank$ranking
}
}
