% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation}
\alias{get_evaluation}
\title{Gets performance data frame from a cross-validated model}
\usage{
get_evaluation(model)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf_evaluate]{rf_evaluate()}}.}
}
\value{
A data frame with evaluation scores. The following columns are shown:
\itemize{
\item \code{model}: Identifies the given model. The values are "Full", (original model introduced into \code{\link[=rf_evaluate]{rf_evaluate()}}), "Training" (model trained on an independent training spatial fold), and "Testing" (predictive performance of the training model on an independent testing spatial fold). The performance values of the "Testing" model represent the model performance on unseen data, and hence its ability to generalize.
\item \code{metric}: Four values representing different evaluation metrics, "rmse", "nrmse", "r.squared", and "pseudo.r.squared".
\item \code{mean}, \code{sd}, \code{min}, and \code{max}: Average, standard deviation, minimum, and maximum of each metric across the evaluation (cross-validation) iterations.

}
}
\description{
Returns performance metrics produced by \code{\link[=rf_evaluate]{rf_evaluate()}}.
}
\examples{
if(interactive()){

#loading data
data(plant_richness_df)
data(distance_matrix)

#fitting a random forest model
rf.model <- rf(
  data = plant_richness_df,
  dependent.variable.name = "richness_species_vascular",
  predictor.variable.names = colnames(plant_richness_df)[5:21],
  distance.matrix = distance_matrix,
  distance.thresholds = 0,
  n.cores = 1,
  verbose = FALSE
)

#evaluating the model with spatial cross-validation
rf.model <- rf_evaluate(
  model = rf.model,
  xy = plant_richness_df[, c("x", "y")],
  n.cores = 1,
  verbose = FALSE
)

#getting evaluation results from the model
x <- get_evaluation(rf.model)
x

}
}
\seealso{
\code{\link[=rf_evaluate]{rf_evaluate()}}, \code{\link[=plot_evaluation]{plot_evaluation()}}, \code{\link[=print_evaluation]{print_evaluation()}}
}
