% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.kde.R
\name{sf.kde}
\alias{sf.kde}
\alias{sp.kde}
\title{Spatial kernel density estimate}
\usage{
sf.kde(
  x,
  y = NULL,
  bw = NULL,
  ref = NULL,
  res = NULL,
  standardize = FALSE,
  scale.factor = NULL,
  mask = FALSE
)
}
\arguments{
\item{x}{sp SpatialPointsDataFrame object}

\item{y}{Optional values, associated with x coordinates, 
to be used as weights}

\item{bw}{Distance bandwidth of Gaussian Kernel, must be units 
of projection}

\item{ref}{A terra SpatRaster, sf class object or c[xmin,xmax,ymin,ymax] 
vector to estimate the kde extent}

\item{res}{Resolution of raster when ref not SpatRaster}

\item{standardize}{Standardize results to 0-1 (FALSE/TRUE)}

\item{scale.factor}{Optional numeric scaling factor for the KDE (eg., 10000),
to account for very small estimate values}

\item{mask}{(TRUE/FALSE) mask resulting raster if ref is provided
as a SpatRaster}
}
\value{
a terra SpatRaster class object containing kernel density estimate
}
\description{
A weighted or unweighted Gaussian Kernel Density estimate 
             for point spatial data
}
\details{
The automatic bandwidth selection for unweighted KDE uses the Wand & Jones (1994)
univariate plug-in whereas, weighted KDE's use the Duong & Hazelton (2005) smoothed
cross-validation for creating a diagonal bandwidth matrix.
}
\examples{
\donttest{ 
library(sf) 
library(terra) 
  
data(meuse, package = "sp")
meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                  agr = "constant") 
  			
# Unweighted KDE (spatial locations only)				
pt.kde <- sf.kde(x = meuse, bw = 1000, standardize = TRUE, 
                 scale.factor = 10000, res=40)
  plot(pt.kde, main="Unweighted kde")
    plot(st_geometry(meuse), pch=20, col="red", add=TRUE) 

# Weighted KDE using cadmium and extent with automatic bandwidth selection
( e <- st_bbox(meuse)[c(1,3,2,4)] ) 
cadmium.kde <- sf.kde(x = meuse, y = meuse$cadmium, ref = e,  
                      standardize = TRUE, 
					  scale.factor = 10000, res=40)
plot(cadmium.kde)
  plot(st_geometry(meuse), pch=20, col="red", add=TRUE)
 			
}

}
\references{
Duong, T. & Hazelton, M.L. (2005) Cross-validation bandwidth matrices for multivariate 
  kernel density estimation. Scandinavian Journal of Statistics, 32, 485-506. 

Wand, M.P. & Jones, M.C. (1994) Multivariate plug-in bandwidth selection. Computational 
  Statistics, 9, 97-116.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
