% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.Zscore.R
\name{raster.Zscore}
\alias{raster.Zscore}
\title{Modified z-score for a raster}
\usage{
raster.Zscore(x, p.value = FALSE, file.name = NULL, ...)
}
\arguments{
\item{x}{A raster class object}

\item{p.value}{Return p-value rather than z-score raster (FALSE/TRUE)}

\item{file.name}{Name of raster written to disk}

\item{...}{Additional arguments passed to writeRaster}
}
\value{
raster class object or raster written to disk
}
\description{
Calculates the modified z-score for all cells in a raster
}
\note{
Since this functions needs to operate on all of the raster values, it is not memory safe
}
\examples{
\dontrun{
library(raster)
r <- raster(nrows=824, ncols=767, xmn=2451905, xmx=3218905, 
            ymn=-2744771, ymx=-1920771, resolution = 5000)
  r[] <- runif(ncell(r), 0, 1)

# Modified z-score
z <- raster.Zscore(r)

# P-value
p <- raster.Zscore(r, p.value = TRUE)
}	

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
