# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Verify that the counting rule CR(r,1) holds
#'
#' This is an implementation of the algorithm described in Section 3 of
#' Hosszejni and Fruehwirth-Schnatter (2022). The algorithm is used to verify
#' that the counting rule CR(r,1) holds for the sparsity pattern of the transpose
#' of a factor loading matrix. As detailed in Section 2 of the same paper, if
#' CR(r,1) holds, then the idiosyncratic variances are generically identified.
#' If CR(r,1) does not hold, then we do not know whether the idiosyncratic
#' variances are identified or not.
#'
#' @param delta an `m` x `r` matrix of `0`s and `1`s, where `delta(i,j) == 1` if and only if
#'    the i-th observation loads on the j-th factor
#' @returns `TRUE` if CR(`r`,`1`) holds, `FALSE` otherwise
#' @keywords models multivariate
#' @concept factor analysis variance identification
#' @seealso [stats::factanal()]
#' @references Hosszejni and Fruehwirth-Schnatter (2022). "Cover It Up! Bipartite
#'    Graphs Uncover Identifiability in Sparse Factor Analysis". arXiv:2211.00671
#' @example inst/examples/counting_rule_holds.R
#' @export
counting_rule_holds <- function(delta) {
    .Call(`_sparvaride_counting_rule_holds`, delta)
}

