% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_evolution.R
\name{screen_nsga2_parameters}
\alias{screen_nsga2_parameters}
\title{Screens NSGA-2 related parameters, guiding which to select for evolving
parameter sets}
\usage{
screen_nsga2_parameters(function_to_evaluate, nsga2_user_set_parameters,
  nsga_sensitivity_parameters, nsga2_settings)
}
\arguments{
\item{function_to_evaluate}{A user-defined function that NSGA2 seeks to
minimise}

\item{nsga2_user_set_parameters}{An object containing the emulator input
and output names, the input parameters for function to evaluate, minimum
and maximum values for emulator inputs. These should be set using the
function that creates that object prior to running this method,
nsga2_set_user_params}

\item{nsga_sensitivity_parameters}{an object containing the minimum and
maximum values of generation number, crossover probability and mutation
probability to be assessed}

\item{nsga2_settings}{An object containing the population size, number
of generations, crossover probability and mutation probability to be
assessed}
}
\value{
Output showing the results of this sensitivity analysis for the
NSGA-2 parameters
}
\description{
This method performs a sensitvity analysis of key settings for the nsga2
algorithm. Different values of generation number, crossover and mutation
rate are assessed and the values for each objective, along with the
variance of the parameter inputs are written out to file in .csv format
so the user can assess which settings are best suited to the chosen
application. Values for the crossover and mutation distribution indices,
used in simulated binary crossover, are left at their default settings,
but can be overwritten when running the emulator_parameter_evolution method.
}
