% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_plotting.R
\name{oat_plotResultDistribution}
\alias{oat_plotResultDistribution}
\title{For stochastic simulations plots the distribution of results for each parameter value}
\usage{
oat_plotResultDistribution(FILEPATH, PARAMETERS, MEASURES, MEASURE_SCALE,
  CSV_FILE_NAME, BASELINE, PMIN = NULL, PMAX = NULL, PINC = NULL,
  PARAMVALS = NULL, TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL,
  output_types = c("pdf"), outliers = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where either the simulation runs or single CSV file result can be found}

\item{PARAMETERS}{Array containing the names of the parameters for which local analyses are being conducted}

\item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}

\item{MEASURE_SCALE}{An array containing the measure used for each of the output measures (i.e. microns, microns/min).  Used to label graphs}

\item{CSV_FILE_NAME}{Name of the file created that summarises the median value of each measure for every run. This specifies what that file should be called (e.g. Medians.csv).}

\item{BASELINE}{Array containing the values assigned to each of these parameters in the calibrated baseline}

\item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space}

\item{PINC}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PARAMVALS}{Array containing a list of strings for each parameter, each string containing comma separated values that should be assigned to that parameter. Thus sampling can be performed for specific values for each parameter, rather than a uniform incremented value. This replaces the PMIN, PMAX, and PINC where this method is used}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}

\item{output_types}{File formats in which graphs should be produced}

\item{outliers}{Whether outliers int he data should be removed}
}
\description{
Only applicable for stochastic simulations where the results are provided in
the folder structure: this takes each parameter in turn, and creates a boxplot
for each output measure, showing the result distribution for each value of that
parameter.
}
