% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_evolution.R
\name{emulator_parameter_evolution}
\alias{emulator_parameter_evolution}
\title{Evolve parameter sets that meet a desired ensemble outcome}
\usage{
emulator_parameter_evolution(function_to_evaluate, nsga2_user_set_parameters,
  nsga2_settings)
}
\arguments{
\item{function_to_evaluate}{A user-defined function that NSGA2 seeks to
minimise}

\item{nsga2_user_set_parameters}{An object containing the emulator input
and output names, the input parameters for function to evaluate, minimum
and maximum values for emulator inputs. These should be set using the
function that creates that object prior to running this method}

\item{nsga2_settings}{An object containing the population size,
number of generations, crossover probability and mutation probability
to be assessed. Again see the function nsga2_settings to set these
values before running this function}
}
\value{
List containing evolved parameter sets, the output for the
ensemble using those sets, and whether these sets are pareto optimal
}
\description{
This method takes a user specified fitness function and runs the nsga2
algorithm on an ensemble using the nsga2 implementation provided in the
mco package, in an attempt to locate parameters that achieve a desired
response (determined by the fitness function). The method outputs a list
describing the values for each simulation output measure, (or objective,
res), an  evolved set of parameter inputs (par), and a boolean stating
whether the candidate is pareto optimal (pareto.optimal)
}
