\name{Technique 2: One-At-A-Time - Perform Analysis of Results}
\alias{oat_processParamSubsets}
\alias{oat_analyseAllParams}
\alias{oat_graphATestsForSampleSize}
\alias{oat_plotResultDistribution}
\title{One-At-A-Time - Perform Analysis of Results}
\description{The robustness of a simulation to parameter alteration can be determined through the use of this approach. Following the method described by Read et al in the reference below, the value of each parameter is adjusted independently, with the remaining parameters staying unchanged from their calibrated value. Each parameter is considered in turn.  For each value that the parameter was given, the results of each simulation run are read in to R, and the median values of the output measures calculated. This creates a set of median output values for each parameter value. This set is then compared to a set of median output measures where the parameter was set to its calibrated value, using the Vargha-Delaney A-Test (2000). This test gives an indication of how different the two sets of results are. The set of A-Test results for each parameter is output to a CSV file for reference. Finally, a graph for each parameter, showing the A-Test results for each parameter value and each simulation output measure.\cr
\cr
\bold{Note:} The package expects that the results to be analysed are within a set folder structure. For an explanation of what this structure should be, see figure OAT_Folder_Struc.png in the extdata folder within this package, or the tutorial available on the project website.\cr
\cr
There are four methods available:\cr
\bold{oat_processParamSubsets}: This method examines each parameter that is to be analysed in turn, starting with the minimum value it has been assigned and works through all values up to and including the maximum in the range.  For each value, the median of each output measure is calculated for each run that has been performed, and these stored in a CSV file within the folder for this parameter value (file given the name set in MEDIANSFILENAME). For example, if the parameter value is 0, and 300 runs have been performed where this is the case, a file is created containing the median of both the Velocity and Displacement output measure for each of the 300 runs. This set of medians can then be compared with the known simulation behaviour at the baseline. \cr
\bold{oat_analyseAllParams}: Examines each parameter in turn, reading in the medians of each output measure and comparing them to that of the simulation baseline results using the A-Test. As an example, consider one of the parameters we are analysing in the example set in the tutorial on the project website, chemoLowerLinearAdjust. This has a baseline value of 0.04. The simulation has two output measures, Velocity and Displacement. The method will read in the median results generated by the first method where the parameter value is its calibrated value. Then, it will, in turn, read in the median results for every other parameter value. So, for example, the minium value for chemoLowerLinearAdjust is 0.015. The method will read in the medians for all simulation runs for this value. For each output measure, the sets of median values are then compared using the Vargha-Delaney A-Test (2000), which indicates 'how different' the two sets of results are, or the effect the parameter value change has had on the simulation result. The next value for this parameter is then considered, and the same process followed.  Once this is all complete, the A-Test scores for each parameter value comparison are output to a CSV file, an example of which can be seen in the data folder of this package (OAT_Example_ATests_chemoLowerLinearAdjust.csv).\cr
\bold{oat_graphATestsForSampleSize}: This takes each parameter in turn and creates a plot showing A-Test score against parameter value.  This makes it easy to determine how the effect that changing the parameter has had on simulation results.  Two examples can be found in the extdata folder of this package (OAT_chemoLowerLinearAdjust_Displacement.pdf and OAT_chemoUpperLinearAdjust.pdf).\cr
\bold{oat_plotResultDistribution}: This takes each parameter in turn, and creates a boxplot for each output measure, showing the result distribution for each value of that parameter. An example can be found in the extdata folder of this package (chemoLowerLinearAdjust_DisplacementBP.pdf).
} 
\usage{
oat_processParamSubsets(FILEPATH,PARAMETERS,PMIN,PMAX,PINC,
	NUMRUNSPERSAMPLE,MEASURES,RESULTFILEFORMAT,
	RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,
	OUTPUTCOLEND,MEDIANSFILEFORMAT,MEDIANSFILENAME)

oat_analyseAllParams(FILEPATH,PARAMETERS,BASELINE,PMIN,PMAX,
	PINC,MEASURES,MEDIANSFILEFORMAT,MEDIANSFILENAME,
	ATESTRESULTSFILENAME)

oat_graphATestsForSampleSize(FILEPATH,PARAMETERS,PMIN,PMAX,
	PINC,MEASURES,ATESTSIGLEVEL,ATESTRESULTSFILENAME,
	TIMEPOINT,TIMEPOINTSCALE)

oat_plotResultDistribution(FILEPATH,PARAMETERS,PMIN,PMAX,
	PINC,MEASURES,MEASURE_SCALE,MEDIANSFILEFORMAT,
	MEDIANSFILENAME,TIMEPOINT,TIMEPOINTSCALE)
}
\arguments{
  \item{FILEPATH}{Directory where the simulation runs can be found}
  \item{PARAMETERS}{Array containing the names of the parameters of which parameter samples will be generated}
  \item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}
  \item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space}
  \item{PINC}{Array containing the increment value that should be applied for each parameter. For example, a parameter could have a minimum value of 10, and maximum value of 100, and be incremented by 10}
  \item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter subset. This figure is generated through Aleatory Analysis}
  \item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}
  \item{RESULTFILEFORMAT}{The file format output by the simulation. Spartan can process XML or CSV output formats}
  \item{RESULTFILENAME}{Name of the simulation results file (e.g. "trackedCells_Close"). Note no file extension}
  \item{ALTERNATIVEFILENAME}{In some cases, it may be relevant to read from a further results file if he initial file contains no results. This filename is set here}
  \item{OUTPUTCOLSTART}{Column number in the results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates}
  \item{OUTPUTCOLEND}{Column number in the results file where the last output measure is}
  \item{MEDIANSFILEFORMAT}{File format for the median distribution files produced from simulation results. Can be either XML or CSV} 
  \item{MEDIANSFILENAME}{If oat_processParamSubsets is used, this analyses the results of replicate simulation runs and creates a file containing the median value of each measure for every run. This specifies what that file should be called (e.g. Medians.csv)}
  \item{BASELINE}{Array containing the values assigned to each of these parameters in the calibrated baseline}
  \item{ATESTRESULTSFILENAME}{File name of the ATests result summary file created by oat_analyseAllParams. For one timepoint, this could be ATests.csv}
  \item{ATESTSIGLEVEL}{The A-Test determines if there is a large difference between two sets if the result is greater than 0.21 either side of the 0.5 line. Should this not be suitable, this can be changed here}
  \item{MEASURE_SCALE}{An array containing the measure used for each of the output measures (i.e. microns, microns/min).  Used to label graphs}
  \item{TIMEPOINT}{Implemented so this method can be used when analysing multiple simulation timepoints.  NULL in this case.  See Technique 2: OAT Analysis Over Time}
  \item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints.  NULL in this case.  See Technique 2: OAT Analysis Over Time}
}
\references{This technique is described by Read et al (2011) in their paper: Techniques for Grounding Agent-Based Simulations in the Real Domain: a case study in Experimental Autoimmune Encephalomyelitis"
}
\examples{
# THE CODE IN THIS EXAMPLE IS THE SAME AS THAT USED IN THE TUTORIAL, AND
# THUS YOU NEED TO DOWNLOAD THE TUTORIAL DATA SET AND SET FILEPATH
# CORRECTLY TO RUN THIS

##---- Firstly, declare the parameters required for the four functions ----
# A: WHERE THE RESULTS FOR EACH CURVE ARE
FILEPATH<-"/media/FreeAgent/package_Test_Data/OAT/"
# B: AN ARRAY OF THE PARAMETERS WHICH HAVE BEEN PERTURBED OR ARE
# BEING ANALYSED
PARAMETERS<-c("thresholdBindProbability","chemoThreshold",
"chemoUpperLinearAdjust","chemoLowerLinearAdjust",
"maxVCAMeffectProbabilityCutoff","vcamSlope")
#C: ARRAY OF MINIMUM VALUES
PMIN<-c(0,0.10,0.10,0.015,0.1,0.25,8)
# D: ARRAY OF MAXIMUM VALUES
PMAX<-c(100,0.9,0.50,0.08,1.0,5.0,12)
# E: ARRAY OF PARAMETER INCREMENT
PINC<-c(10,0.1,0.05,0.005,0.05,0.25,1)
# F: THE NUMBER OF TIMES THE SIMULATION HAS BEEN RUN FOR EACH
# PARAMETER SET
NUMRUNSPERSAMPLE<-300
# G: THE OUTPUT MEASURES (ARRAY)
MEASURES<-c("ChemoEndVal","VCAMEndVal","TimePointLTinChange",
	"TimePointLTiChange","TimePointMature","Area")
# H: FORMAT OF THE SIMULATOR RESULT FILES
RESULTFILEFORMAT<-"csv"
# I: WHAT THE SIMULATION RESULT FILE IS CALLED
RESULTSFILENAME<-"finalPatchStats_Endpoint"
# J: NAME OF AN ALTERNATIVE RESULTS FILE IF NECESSARY
ALTERNATIVEFILENAME<-NULL
# K: WHERE THE OUTPUT MEASURES START IN THE RESULTS FILE FROM THE
# SIMULATION. SAVES READING THE WHOLE FILE & AVOIDS POTENTIAL
# PROBLEMS WHERE THE FIRST COLUMN IS DUPLICATED (eg A CELL LABEL)
OUTPUTCOLSTART<-2
# L: WHERE THE OUTPUT MEASURES END
OUTPUTCOLEND<-9
# M: FILE FORMAT FOR THE MEDIAN OUTPUT FILE - XML OR CSV
MEDIANSFILEFORMAT<-"csv"
# N: NAME TO BE GIVEN TO EACH FILE OF GENERATED MEDIAN MEASURES FOR
# EACH PARAMETER
MEDIANSFILENAME<-"EgSet_Medians"
# O: NAME TO BE GIVEN TO THE FILES CONTAINING THE A-TEST RESULTS FOR
# EACH PARAMETER
ATESTRESULTSFILENAME<-"EgSet_ATests"
# P: BASELINE PARAMETER VALUES
BASELINE<-c(50,0.3,0.2,0.04,0.60,1.0,12)
# Q: LEVEL AT WHICH A-TEST RESULTS ARE SIGNIFICANT
ATESTSIGLEVEL<-0.21
# R: MEASUREMENTS FOR GRAPHING
MEASURE_SCALE<-c(NULL,NULL,"Simulation Steps","Simulation Steps",
	"Simulation Steps","Square Pixels")
# S: TIMEPOINTS - USED WHEN ANALYSING OVER TIME-NOT IN THIS CASE
TIMEPOINTS<-NULL
# T: TIMEPOINTSCALE - USED WHEN ANALYSING OVER TIME-NOT IN THIS CASE
TIMEPOINTSCALE<-NULL

# NOW RUN THE METHODS

\dontrun{
# DONTRUN IS SET SO THIS IS NOT EXECUTED WHEN PACKAGE IS COMPILED - BUT THIS
# HAS BEEN TESTED WITH THE TUTORIAL DATA

# A - GENERATE THE MEDIAN SETS FOR EACH SET OF RUNS FOR THE
# PARAMETER VALUE
oat_processParamSubsets(FILEPATH,PARAMETERS,PMIN,PMAX,PINC,
	NUMRUNSPERSAMPLE,MEASURES,RESULTSFILEFORMAT,
	RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,
	OUTPUTCOLEND,MEDIANSFILEFORMAT,MEDIANSFILENAME)

# B - RUN THE ATEST FOR EACH PARAMETER VALUE, AND EACH PARAMETER
oat_analyseAllParams(FILEPATH,PARAMETERS,BASELINE,PMIN,PMAX,
	PINC,MEASURES,MEDIANSFILEFORMAT,MEDIANSFILENAME,
	ATESTRESULTSFILENAME)

# C - GRAPH THE RESULTS FOR ALL MEASURES FOR EACH PARAMETER
oat_graphATestsForSampleSize(FILEPATH,PARAMETERS,PMIN,PMAX,PINC,
	MEASURES,ATESTSIGLEVEL,ATESTRESULTSFILENAME,TIMEPOINTS,
	TIMEPOINTSCALE)

# D - GRAPH THE DISTRIBUTION OF THE RESULTS FOR THIS MEASURE, FOR
# THIS PARAMETER
oat_plotResultDistribution(FILEPATH,PARAMETERS,PMIN,PMAX,PINC,
	MEASURES,MEASURE_SCALE,MEDIANSFILEFORMAT,MEDIANSFILENAME,
	TIMEPOINTS,TIMEPOINTSCALE)
}
}
\keyword{OAT}
\keyword{Parameter}
\keyword{Analysis}
\keyword{A-Test}
