% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_copy_to}
\alias{sdf_copy_to}
\alias{sdf_import}
\title{Copy an Object into Spark}
\usage{
sdf_copy_to(sc, x, name, memory, repartition, overwrite, struct_columns, ...)

sdf_import(x, sc, name, memory, repartition, overwrite, struct_columns, ...)
}
\arguments{
\item{sc}{The associated Spark connection.}

\item{x}{An \R object from which a Spark DataFrame can be generated.}

\item{name}{The name to assign to the copied table in Spark.}

\item{memory}{Boolean; should the table be cached into memory?}

\item{repartition}{The number of partitions to use when distributing the
table across the Spark cluster. The default (0) can be used to avoid
partitioning.}

\item{overwrite}{Boolean; overwrite a pre-existing table with the name \code{name}
if one already exists?}

\item{struct_columns}{(only supported with Spark 2.4.0 or higher) A list of
columns from the source data frame that should be converted to Spark SQL
StructType columns.
The source columns can contain either json strings or nested lists.
All rows within each source column should have identical schemas (because
otherwise the conversion result will contain unexpected null values or
missing values as Spark currently does not support schema discovery on
individual rows within a struct column).}

\item{...}{Optional arguments, passed to implementing methods.}
}
\description{
Copy an object into Spark, and return an \R object wrapping the
copied object (typically, a Spark DataFrame).
}
\section{Advanced Usage}{


\code{sdf_copy_to} is an S3 generic that, by default, dispatches to
\code{sdf_import}. Package authors that would like to implement
\code{sdf_copy_to} for a custom object type can accomplish this by
implementing the associated method on \code{sdf_import}.
}

\examples{

sc <- spark_connect(master = "spark://HOST:PORT")
sdf_copy_to(sc, iris)

}
\seealso{
Other Spark data frames: 
\code{\link{sdf_random_split}()},
\code{\link{sdf_register}()},
\code{\link{sdf_sample}()},
\code{\link{sdf_sort}()}
}
\concept{Spark data frames}
