% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_pca.R
\name{ml_pca}
\alias{ml_pca}
\title{Spark ML -- Principal Components Analysis}
\usage{
ml_pca(x, features = tbl_vars(x), k = length(features),
  ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{features}{The columns to use in the principal components
analysis. Defaults to all columns in \code{x}.}

\item{k}{The number of principal components.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments. The \code{data} argument can be used to
specify the data to be used when \code{x} is a formula; this allows calls
of the form \code{ml_linear_regression(y ~ x, data = tbl)}, and is
especially useful in conjunction with \code{\link{do}}.}
}
\description{
Perform principal components analysis on a Spark DataFrame.
}
\seealso{
Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_gradient_boosted_trees}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}
\concept{Spark ML routines}
