% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spark.matrix}
\alias{spark.matrix}
\title{Spark lines for rows of a matrix.}
\usage{
\method{spark}{matrix}(data, width = c("data", "auto", "screen"),
  print = TRUE, common_scale = TRUE, ...)
}
\arguments{
\item{data}{The matrix to plot.}

\item{width}{The width (number of characters) of the output.
\sQuote{data} means that it will match the length of the data.
\sQuote{screen} means that it will be scaled to match the
width of the screen. \sQuote{auto} means \sQuote{data}
if the length of the data is not longer than the screen width,
and \sQuote{screen} otherwise.}

\item{print}{Whether to show the result on the screen. (If \code{FALSE},
it will be only returned.)}

\item{common_scale}{Whether to plot all rows on a common scale.
If \code{FALSE}, then all rows will have their own scales.}

\item{...}{Passed to \code{spark.default}. E.g. it can be
used to mark the minimum and/or maximum values.}
}
\value{
Character scalar containing the spark line.
}
\description{
Spark lines for rows of a matrix.
}
\examples{
spark(volcano)

spark(t(EuStockMarkets), width="auto", common_scale = FALSE)
}
\seealso{
Other spark: \code{\link{spark.default}};
  \code{\link{spark}}
}

