% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spFSR.R
\name{plot.spFSR}
\alias{plot.spFSR}
\title{Ploting a spFSR object}
\usage{
\method{plot}{spFSR}(x, errorBar = FALSE, annotateBest = FALSE, se = FALSE, ...)
}
\arguments{
\item{x}{a \code{spFSR} object}

\item{errorBar}{If \code{TRUE}, an error bar of +/- 1 standard deviation will be included around the mean error scoring value at each iteration. When it is \code{TRUE}, the \code{ylim} argument cannot be used. The default is \code{FALSE}.}

\item{annotateBest}{If \code{TRUE}, the best result will be highlighted and annotated. The default is \code{FALSE}.}

\item{se}{If \code{TRUE}, an error bar of \eqn{\pm} standard error will be included around the mean error scoring value at each iteration. When it is \code{TRUE}, the \code{ylim} argument cannot be used. The \code{se} does not produce any error bar if \code{errorBar} is set as \code{FALSE}. Note that if the standard error is used, the error bar has a narrower range. The default is \code{FALSE}.}

\item{...}{Additional plot parameters that can be passed into the plot function.}
}
\value{
Plot error scoring values vs iterations of a spFSR object with an error bar (if included).
}
\description{
Plot for a spFSR object. It provides a scatterplot of scoring values vs. iteration. The error bar of scoring values at each iteration can be included. It also allows user to identify the iteration which yields the best scoring value. See \link[spFSR]{spFeatureSelection} for example.
}
\seealso{
\link[spFSR]{plotImportance} and \link[spFSR]{spFeatureSelection}.
}
