% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gccm.R
\name{gccm}
\alias{gccm}
\title{geographical convergent cross mapping}
\usage{
gccm(
  cause,
  effect,
  data,
  libsizes = NULL,
  E = 3,
  nb = NULL,
  RowCol = NULL,
  trendRM = TRUE
)
}
\arguments{
\item{cause}{Name of causal variable.}

\item{effect}{Name of effect variable.}

\item{data}{The observation data, must be \code{sf} or \code{SpatRaster} object.}

\item{libsizes}{(optional) A vector of library sizes to use.}

\item{E}{(optional) The dimensions of the embedding.}

\item{nb}{(optional) The neighbours list.}

\item{RowCol}{(optional) Matrix of selected row and cols numbers.}

\item{trendRM}{(optional) Whether to remove the linear trend.}
}
\value{
A \code{data.frame}.
}
\description{
geographical convergent cross mapping
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData")[1],
                       quiet=TRUE)
gccm("HOVAL", "CRIME", data = columbus)
}
