% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{RLP}
\alias{RLP}
\title{Estimate regime-dependent local projections}
\usage{
RLP(
  data,
  horizons = 1,
  freq = "month",
  type = "const",
  p = 1,
  lag.ic = NULL,
  lag.max = NULL,
  NW = FALSE,
  NW_lags = NULL,
  NW_prewhite = NULL,
  regime = NULL,
  regime.method = "rf",
  regime.n = 2
)
}
\arguments{
\item{data}{data.frame, matrix, ts, xts, zoo: Endogenous regressors}

\item{horizons}{int: forecast horizons}

\item{freq}{string: frequency of data ('day', 'week', 'month', 'quarter', or 'year')}

\item{type}{string: type of deterministic terms to add ('none', 'const', 'trend', or 'both')}

\item{p}{int: lags}

\item{lag.ic}{string: information criterion to choose the optimal number of lags ('AIC' or 'BIC')}

\item{lag.max}{int: maximum number of lags to test in lag selection}

\item{NW}{boolean: Newey-West correction on variance-covariance matrix}

\item{NW_lags}{int: number of lags to use in Newey-West correction}

\item{NW_prewhite}{boolean: TRUE prewhite option for Newey-West correction (see sandwich::NeweyWest)}

\item{regime}{string: name or regime assignment vector in the design matrix (data)}

\item{regime.method}{string: regime assignment technique ('rf', 'kmeans', 'EM', 'BP')}

\item{regime.n}{int: number of regimes to estimate (applies to kmeans and EM)}
}
\value{
list of lists, one list per regime, each regime with objects with elements \code{data}, \code{model}, \code{forecasts}, \code{residuals};
if there is more than one forecast horizon estimated, then \code{model}, \code{forecasts}, \code{residuals}
will each be a list where each element corresponds to a single horizon
}
\description{
Estimate a regime-dependent local projection (i.e. a state-dependent LP), with an exogenous state indicator, of the specification:
\deqn{Y_{t+h} = X_t \beta_{s_t} + \epsilon_t}
where \emph{t} is the time index, and \emph{s} is a mutually exclusive state of the world observed at time \emph{t}. When the regime vector is
not supplied by the user, then a two-state regime series is estimated via random forest.
}
\examples{
\donttest{

  # simple time series
  AA = c(1:100) + rnorm(100)
  BB = c(1:100) + rnorm(100)
  CC = AA + BB + rnorm(100)
  date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
  Data = data.frame(date = date, AA, BB, CC)
  # add regime
  Data = dplyr::mutate(Data, reg = dplyr::if_else(AA > median(AA), 1, 0))

  # local projection forecasts
  rlp =
    sovereign::RLP(
      data = Data,
      regime = 'reg',
      horizon = c(1:10),
      freq = 'month',
      p = 1,
      type =  'const',
      NW = TRUE,
      NW_lags = 1,
      NW_prewhite = FALSE)

 # impulse response function
 rirf = sovereign::rlp_irf(rlp)

}

}
\references{
\enumerate{
\item Jorda, Oscar "\href{https://www.aeaweb.org/articles?id=10.1257/0002828053828518}{Estimation and Inference of Impulse Responses by Local Projections}" 2005.
}
}
\seealso{
\code{\link[=LP]{LP()}}

\code{\link[=lp_irf]{lp_irf()}}

\code{\link[=RLP]{RLP()}}

\code{\link[=rlp_irf]{rlp_irf()}}
}
