% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch_postprocessing.R
\name{forcePerPath}
\alias{forcePerPath}
\title{Force per path}
\usage{
forcePerPath(pitch, pitchCands, pitchCert, pitchCenterGravity, certWeight)
}
\arguments{
\item{pitch}{numeric vector representing our best guess at pitch contour,
which we are now attempting to improve by minimizing its elastic tension}

\item{pitchCands}{a matrix of multiple pitch candidates per fft frame. Each
column is one fft frame, each row is one candidate (the last row is always
"manual")}

\item{pitchCert}{a matrix of the same dimensionality as pitchCands specifying
our certainty in pitch candidates}

\item{pitchCenterGravity}{numeric vector giving the mean of all pitch
candidates per fft frame weighted by our certainty in each of these
candidates}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}
}
\value{
Returns a numeric vector of the same length as \code{pitch} that
  gives the total force acting on the snake at each point.
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for postprocessing of pitch contour. Returns the
total force acting on a snake (sum of internal and external gradients, i.e.
of the elastic force trying to straighten the snake [internal] and of the
force pushing the snake towards the most certain pitch estimates [external])
}
\keyword{internal}
