% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{print.list.applyChanges}
\alias{print.list.applyChanges}
\title{Pretty printing for the result of \code{\link{applyChanges}}.}
\usage{
\method{print}{list.applyChanges}(x, ...)
}
\arguments{
\item{x}{[list.applyChanges] The output of \code{\link{applyChanges}}.}

\item{...}{Unused; only for consistency with \code{\link{print}}.}
}
\value{
[list.applyChanges] The same object that was given as \code{x}.
}
\description{
Pretty printing for the result of \code{\link{applyChanges}}.
}
\details{
The output of \code{\link{applyChanges}} is a list, potentially a very long one, and difficult to read. To make it easier to digest, this function only prints the \code{$end} element, i.e. the final shapes produced by the application of all of the sound changes.
}
\examples{
# prepare sample data
dataset <- loadSampleDataset ("data-capitals")
changes <- list (loadSampleDataset("change-dl2l"), loadSampleDataset("change-rhotacism"))
# apply the changes
applyChanges (dataset, changes, "ORTHOGRAPHY.German")
applyChanges (dataset, changes, "ORTHOGRAPHY.German", "ORTHOGRAPHY.Polish", highlight="console")
}
\seealso{
\code{\link{applyChanges}}, \code{\link{print.tree.applyChanges}}
}
