% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{checkUnit}
\alias{checkUnit}
\title{Check if the \code{unit} argument is correct.}
\usage{
checkUnit(unit)
}
\arguments{
\item{unit}{[character] The string to check.}
}
\value{
[character] Either \code{"o"} or \code{"w"}.
}
\description{
Makes sure the \code{unit} argument has one of the many available values.
}
\details{
Functions which produce contingency tables, \code{\link{coocc}} and \code{\link{summary}}, have an argument \code{count} which can take as many as eight different values which all point to just two unique behaviours. \code{checkCount} reduces this multitude to just the two meaningful values. It also throws an error if \code{count} is none of the eight possibilities.
}
\examples{
soundcorrs:::checkUnit ("occ")
soundcorrs:::checkUnit ("occurrence")
}
\seealso{
\code{\link{checkCount}}
}
\keyword{internal}
