% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{lapplyTest}
\alias{lapplyTest}
\title{Apply a function to a list.}
\usage{
lapplyTest(x, fun = chisq.test, ...)
}
\arguments{
\item{x}{[list] The list to which to apply \code{fun}.}

\item{fun}{[function] The function which to apply to \code{data}. Must return an object containing an element named \code{p.value}. Defaults to \code{\link{chisq.test}}.}

\item{...}{Additional arguments passed to \code{fun}.}
}
\value{
[list.lapplyTest] A list of outputs of \code{fun}.
}
\description{
Takes a list and applies to each of its elements a function, returning a list of outputs. Primary intended for tests of independence on a list of contingency tables.
}
\details{
When applying a function to a list, any iteration that results in an error, breaks the whole loop. This is not always the most convenient behaviour, in particular when the function is a statistical test and the error is to do with sparse data in one of the tables in the list. \code{lapplyTest} is a wrapper around \code{base::lapply} which only differs from the original in its treatment of errors. It saves the message associated with the error or warning, but then continues to the next iteration rather than quitting the loop altogether.
}
\examples{
dataset <- loadSampleDataset ("data-abc")
lapplyTest (allCooccs(dataset))
lapplyTest (allCooccs(dataset), fisher.test, simulate.p.value=TRUE)
}
\seealso{
\code{\link{summary.list.lapplyTest}}, \code{\link{allCooccs}}
}
