\name{OmMeasurement}
\Rdversion{1.1}

\docType{class}

\alias{OmMeasurement}
\alias{OmMeasurement-class}
\alias{show,OmMeasurement-method}
\alias{print,OmMeasurement-method}
\alias{toString,OmMeasurement-method}
\alias{sosResult,OmMeasurement-method}
\alias{sosProcedures,OmMeasurement-method}
\alias{sosFeatureIds,OmMeasurement-method}
\alias{sosFeaturesOfInterest,OmMeasurement-method}
\alias{sosGetCRS,OmMeasurement-method}
\alias{names.OmMeasurement}

\alias{as.data.frame.OmMeasurement}
\alias{as.SpatialPointsDataFrame.OmMeasurement}

\alias{sosUOM,OmMeasurement-method}


\title{Class and Construction Function for om:Measurement Elements}

\description{Classes and construction functions for objects from the OGC Observations and Measurements specification.}

\section{Objects from the Class}{
Objects can be created by calls to the construction function of the form \code{OmMeasurement(...)}.
}

\usage{
OmMeasurement(samplingTime, procedure, observedProperty, featureOfInterest, 
	result, metadata = NA, resultTime = NULL, resultQuality = NA, 
	parameter = NA) 
}

\section{Slots}{
  \describe{
    \item{\code{featureOfInterest}:}{Object of class \code{"GmlFeature"}: A feature of any type (ISO 19109, ISO 19101), which is a representation of the observation target, being the real-world object regarding which the observation is made.}
    \item{\code{metadata}:}{Object of class \code{"ANY"}: Observation metadata.}
    \item{\code{observedProperty}:}{Object of class \code{"SwePhenomenonProperty"}: Identifies or describes the phenomenon for which the observation result provides an estimate of its value. It must be a property associated with the type of the feature of interest.}
    \item{\code{parameter}:}{Object of class \code{"ANY"}: A general event-specific parameter. This will typically be used to record environmental parameters, or event-specific sampling parameters that are not tightly bound to either the feature-of-interest or the procedure.}
    \item{\code{procedure}:}{Object of class \code{"ANY"}: The description of a process used to generate the result. It must be suitable for the observed property.}
    \item{\code{result}:}{Object of class \code{"ANY"}: Contains the value generated by the procedure. The type of the observation result must be consistent with the observed property, and the scale or scope for the value must be consistent with the quantity or category type.}
    \item{\code{resultQuality}:}{Object of class \code{"ANY"}: Event specific quality of a result.}
    \item{\code{resultTime}:}{Object of class \code{"GmlTimeObjectOrNULL"}: The time when the procedure associated with the observation act was applied. For some observations these are identical, in which case the resultTime may be omitted. However, there are important cases where they differ.}
    \item{\code{samplingTime}:}{Object of class \code{"GmlTimeObjectOrNULL"}: The time that the result applies to the feature-of-interest. This is the time usually required for geospatial analysis of the result.}
  }
}

\section{Extends}{
\bold{OmMeasurement:}
Class \code{"\linkS4class{OmObservation}"}, directly.
Class \code{"\linkS4class{OmObservationOrNULL}"}, by class "OmObservation", distance 2.
}

\section{Methods}{
  \describe{
    \item{sosResult}{\code{signature(obj = "OmMeasurement")}: Get the data in the measurement as a data.frame.}
    \item{sosGetCRS}{\code{signature(obj = "OmMeasurement")}: Get the coordinate reference system used in the feature of interest.}
    
	 }
}

\arguments{
  \item{samplingTime}{See slot description.}
  \item{procedure}{See slot description.}
  \item{observedProperty}{See slot description.}
  \item{featureOfInterest}{See slot description.}
  \item{result}{See slot description.}
  \item{metadata}{See slot description.}
  \item{resultTime}{See slot description.}
  \item{resultQuality}{See slot description.}
  \item{parameter}{See slot description.}
}

\details{
A Measurement contains a \code{\linkS4class{GmlMeasure}}.
}

\value{The construction functions return an object of the respective class.}

\references{Cox, S. (Ed.), Observations and Measurements - Part 1 - Observation schema, Open Geospatial Consortium Inc., OGC 07-022r1, Version: 1.0}

\author{Daniel Nuest \email{daniel.nuest@uni-muenster.de}}

%\note{}
%\section{Warning}{}

\seealso{See also \code{\link{OmObservation-class}}, \code{\linkS4class{GmlMeasure}}.}

\examples{
showClass("OmMeasurement")

# TBD examples for construction function

# TBD examples for sosResult
}

\keyword{classes}
