% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recording_function.R
\name{recording_function}
\alias{recording_function}
\title{Recording functions}
\usage{
recording_function(fn, record_pars = TRUE, record_values = TRUE, predicate)
}
\arguments{
\item{fn}{A test function (class \code{soo_function} or
\code{wrapped_soo_function}).}

\item{record_pars}{[\code{boolean(1)}]\cr If \code{TRUE}, parameter
values (x) will be recorded.}

\item{record_values}{[\code{boolean(1)}]\cr If \code{TRUE}, function
values (y) will be recorded.}

\item{predicate}{[\code{function(par, value, time)}]\cr Predicate
function that returns \code{TRUE} if recording should take place
for the given parameter setting \code{par}, function value
\code{value} and evaluation \code{time}. Note that \code{time} is
measured in function evaluations.}
}
\description{
Return a new function which is identical to the \code{soofunction}
passed in except that evaluated parameter settings and function
values are recorded.
}
\examples{
fn <- recording_function(generate_sphere_function(2))
X <- random_parameters(10, fn)
y <- fn(X)
rv <- recorded_values(fn)
all.equal(rv$par, X)
all.equal(rv$value, y)

## With a predicate
pv <- function(par, value, time)
  time \%\% 3 == 0
fn <- recording_function(generate_sphere_function(2), predicate=pv)
X <- random_parameters(10, fn)
y <- fn(X)
rv <- recorded_values(fn)
all(rv$time \%\% 3 == 0)
all.equal(rv$par, X[, rv$time])
all.equal(rv$value, y[rv$time])

}
\seealso{
\code{\link{recorded_values}} to retrieve the recorded
parameter and function values.
}
