% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_branin.R
\name{generate_branin_function}
\alias{generate_branin_function}
\title{Generator for the Branin test function.}
\usage{
generate_branin_function()
}
\value{
A \code{soo_function}.
}
\description{
This function is a 2D test function. The generator does not take
any parameters. It is defined as
}
\details{
\deqn{f(x) = \displaystyle\left(x_2 - \frac{5.1}{4\pi^2}x_1^2 + \frac{5}{\pi}x_1 - 6\right)^2 + 10\left(1 - \frac{1}{8\pi}\right)\cos(x_1) + 10}
}
\examples{
f <- generate_branin_function()
plot(f, rank=TRUE)

}
\references{
F. H. Branin. 1972. Widely convergent method for finding
multiple solutions of simultaneous nonlinear equations.
IBM J. Res. Dev. 16, 5 (September 1972), 504-522.
}
