% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_fixed_budget.R
\name{with_fixed_budget}
\alias{with_fixed_budget}
\title{Fixed budget expression evaluation

Evaluate \code{expr} with a fixed budget for the number of times
any test function in \code{expr} may be evaluated.}
\usage{
with_fixed_budget(expr, budget)
}
\arguments{
\item{expr}{[\code{expression}]\cr Expression to evaluate}

\item{budget}{[\code{integer(1)}]\cr Maximum number of test
function evaluations that may be performed by \code{expr}.}
}
\value{
A \code{list} with elements \sQuote{par}, \sQuote{value}
and \sQuote{counts} whos contents are identical to the return
value of \code{\link{optim}}
}
\description{
Fixed budget expression evaluation

Evaluate \code{expr} with a fixed budget for the number of times
any test function in \code{expr} may be evaluated.
}
\details{
The main use of this function is in benchmarking
(optimization) algorithms. It ensures that the algorithm does not
perform more than \code{budget} function evaluations by tracking
the number of evaluations performed and raising a
\code{\link{condition}} if the budget is reached. For this to
work, the function must find one and only one \code{soofunction}
object in \code{expr} which will be replaced by a modified test
function that performs the tracking and signalling.

While elegant from a users perspective, this function is not fool
proof. It is possible to construct situations were it will
fail. For example, if the employed optimization algorithm is
written in C and does not use the memory allocation routines
provided by R, then this will certainly lead to memory leaks. You have been warned.
}
\examples{
fn <- generate_sphere_function(10)
res <- with_fixed_budget(optim(random_parameter(fn), fn), 25)
print(res)

}
