% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaggedWave.R
\docType{methods}
\name{addProcess}
\alias{addProcess}
\alias{addProcess,TaggedWave-method}
\alias{addProcess,TaggedWaveMC-method}
\title{Add a process to a Tagged Wave or WaveMC object}
\usage{
addProcess(object, process, output = NULL, duration = NULL)

\S4method{addProcess}{TaggedWave}(object, process, output = NULL, duration = NULL)

\S4method{addProcess}{TaggedWaveMC}(object, process, output = NULL, duration = NULL)
}
\arguments{
\item{object}{An object.}

\item{process}{A description of the process.}

\item{output}{The output of the process.}

\item{duration}{The duration of the process in seconds.}
}
\value{
The object with the process added.
}
\description{
This function takes a \code{TaggedWave} or \code{TaggedWaveMC} object and adds a process
to the \code{processing} slot. This is used to keep a record of the processes that
have been applied to the object.
}
