\name{DT_mohring}
\alias{DT_mohring}
\docType{data}
\title{
Full diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 36 winter bean hybrids, coming from a full diallel design and evaluated for 9 traits. The column male and female origin columns are included as well. 

}
\usage{data("DT_mohring")}
\format{
  The format is:
 chr "DT_mohring"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{

####=========================================####
#### For CRAN time limitations most lines in the
#### examples are silenced with one '#' mark,
#### remove them and run the examples
####=========================================####
data(DT_mohring)
DT <- DT_mohring
head(DT)
# Dummy variables for selfs, crosses, combinations
# in a diallel:
# diagonal (selfs) are dr=0
# upper off diagonal (direct crosses) dr=-1
# lower off-diagonal (reciprocal crosses) dr=1
DT$crosses <- ifelse(DT$Par1 == DT$Par2, 0, 1)
DT$selfs <- ifelse(DT$Par1 == DT$Par2, 1, 0)
DT$dr <- ifelse(as.character(DT$Par1) < as.character(DT$Par2), -1,
                ifelse(as.character(DT$Par1) == as.character(DT$Par2), 0, 1))
# Dummy variable for the cross combinations IDs ignoring the reciprocals
DT$combination<-factor(ifelse(as.character(DT$Par1) <= as.character(DT$Par2),
                              paste(DT$Par1, DT$Par2, sep =""),
                              paste(DT$Par2, DT$Par1, sep ="")) )
##
# GRIFFING MODEL 2 with reciprocal effects ################################
mod1h <- mmer(Ftime ~ 1, data=DT,
              random = ~ Block
              + overlay(Par1, Par2) # GCA male & female overlayed
              + combination # SCA effects
              + combination:dr) # SCA reciprocal effects (if zero there's no reciprocal effects)
summary(mod1h)$varcomp
##                                    VarComp VarCompSE   Zratio 
## Block.Ftime-Ftime                  0.00000   9.32181 0.000000 
## overlay(Par1, Par2).Ftime-Ftime 1276.73089 750.17269 1.701916 
## combination.Ftime-Ftime         1110.99090 330.16921 3.364914 
## combination:dr.Ftime-Ftime        66.02295  49.26876 1.340057 
## units.Ftime-Ftime                418.47949  74.56442 5.612321  
##
# GE2 model, no reciprocal effects #######################################
mod1h <- mmer(Ftime ~ Block + crosses, data=DT,
              random = ~ overlay(Par1, Par2) #VEi GCA (all)
              + overlay(Par1, Par2):crosses  #h.i GCA ignoring selfs (only hybrids)
              + combination:crosses) # SCA ignoring selfs
summary(mod1h)$varcomp
##                                           VarComp  VarCompSE   Zratio
## overlay(Par1, Par2).Ftime-Ftime         2304.1781 1261.63193 1.826347
## overlay(Par1, Par2):crosses.Ftime-Ftime  613.6040  402.74347 1.523560
## combination:crosses.Ftime-Ftime          340.7030  148.56225 2.293335
## units.Ftime-Ftime                        501.6275   74.36075 6.745864
##
# GE3, no reciprocal effects ############################################
mod1h <- mmer(Ftime ~ Block + crosses, data=DT,
              random = ~ overlay(Par1, Par2):crosses # GCAC (only for hybrids)
              + Par1:selfs # SP (GCA males only for inbreds)
              + combination:crosses) # SCA ignoring selfs
summary(mod1h)$varcomp
##                                           VarComp  VarCompSE   Zratio
## overlay(Par1, Par2):crosses.Ftime-Ftime  927.7895  537.91218 1.724797
## Par1:selfs.Ftime-Ftime                  9960.9247 5456.58188 1.825488
## combination:crosses.Ftime-Ftime          341.4567  148.53667 2.298804
## units.Ftime-Ftime                        498.5974   73.92066 6.745035
##
# GE3 with reciprocal effects ###########################################
# In Mohring: mixed model 3 reduced
mod1h <- mmer(Ftime ~ Block + crosses, data=DT,
              random = ~ overlay(Par1, Par2):crosses #GCAC (for hybrids only)
              + Par1:selfs # SP
              + combination:crosses # SCA (hybrids only)
              + combination:dr) # REC (reciprocal effects) (if zero there's no reciprocal effects)
summary(mod1h)$varcomp
##                                             VarComp  VarCompSE   Zratio
## overlay(Par1, Par2):crosses.Ftime-Ftime   927.78742  537.89981 1.724833
## Par1:selfs.Ftime-Ftime                  10001.78854 5456.47578 1.833013
## combination:crosses.Ftime-Ftime           361.89712  148.54264 2.436318
## combination:dr.Ftime-Ftime                 66.43695   49.24492 1.349113
## units.Ftime-Ftime                         416.82960   74.27202 5.612203
##
# GE3 with RGCA + RSCA ##################################################
# In Mohring: mixed model 3
mod1h <- mmer(Ftime ~ Block + crosses, data=DT,
              random = ~ overlay(Par1, Par2):crosses #GCAC (hybrids only)
              + Par1:selfs # SP
              + combination:crosses # SCA
              + overlay(Par1,Par2):dr # RGCA: exclude selfs (if zero there's no reciprocal effects)
              + combination:dr) #RSCA: exclude selfs (if zero there's no reciprocal effects)
summary(mod1h)$varcomp
##                                            VarComp  VarCompSE    Zratio
## overlay(Par1, Par2):crosses.Ftime-Ftime   927.7843  537.88164 1.7248857
## Par1:selfs.Ftime-Ftime                  10001.7570 5456.30125 1.8330654
## combination:crosses.Ftime-Ftime           361.8958  148.53670 2.4364068
## overlay(Par1, Par2):dr.Ftime-Ftime         17.9799   19.92428 0.9024114
## combination:dr.Ftime-Ftime                 30.9519   46.43908 0.6665054
## units.Ftime-Ftime                         416.8274   74.26813 5.6124668

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} }
