\name{F1geno}
\alias{F1geno}
\docType{data}
\title{
Genotypes from an F1(CP) cross to show phasing
}
\description{
This dataset contains genotypic data from a cranberry biparental population published in Covarrubias-Pazaran et al. (2016) where a high density map was built using GBS data. This data is a companion to show the use of the \code{\link{phase.F1}} function which is used to build parental maps imputing the Aa alleles from AaxAa markers which are usually lost during the phasing process by lack of linkage information. This map allow the user to add the hk markers to the parental maps without loosing information for the Aa alleles as JoinMap v4.1 usually does.

}
\usage{data("F1geno")}
\format{
  The format is:
 chr "F1geno"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(F1geno)
F1geno[1:10,1:10]
#maps <- phase.F1(F1geno)
#maps$maternal[1:10,1:10]
#heat <- apply(maps$maternal[,-c(1:6)],2,function(x){as.numeric(as.factor(x))})
#heat[1:10,1:10]
#image(heat)
####=========================================####
#### use variance to remove bad markers
####=========================================####
#plot(apply(heat,1,var))
#jjj <- which(apply(heat,1,var) > .5)
#image(heat[-jjj,])
####=========================================####
#### do bin mapping using ASMap
####=========================================####
}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} and and \code{\link{mmer2}}}
