% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SOMnn.R
\docType{methods}
\name{plot,SOMnn,ANY-method}
\alias{plot,SOMnn,ANY-method}
\alias{plot,SOMnn-method}
\title{Plot method for S4 class \code{SOMnn}}
\usage{
\S4method{plot}{SOMnn,ANY}(x, title = TRUE, col = NA, onlyDefCols = FALSE,
  edit.cols = FALSE, show.legend = TRUE, legend.loc = "bottomright",
  legend.width = 4, window.width = NA, window.height = NA,
  show.box = TRUE, show.counter.border = 0.98, predict = NULL,
  add = FALSE, pch.col = "black", pch = 19, ...)
}
\arguments{
\item{x}{trained som of type \code{SOMnn}.}

\item{title}{\code{logical}; if TRUE, slots name and date are used as main title.}

\item{col}{Defines colours for the classes of the dataset. Possible values include:
\code{NA}: default value; colours are generated with \code{rainbow},  
a \code{vector} of colour definitions or a
\code{data.frame} with categories in the first and respective colours in the second column.}

\item{onlyDefCols}{\code{logical}; if TRUE, only categories are plotted, for which colours are defined. 
Default: FALSE.}

\item{edit.cols}{\code{logical}; if TRUE, colour definitions can be edited interactively before plotting. 
Default: FALSE.}

\item{show.legend}{\code{logical}; if TRUE, a legend is displayed,. Default: TRUE.}

\item{legend.loc}{Legend position as specified for \code{\link{legend}}. Default is \code{"bottomright"}.}

\item{legend.width}{size of the legend.}

\item{window.width}{Manual setting of window width. Default is NA.}

\item{window.height}{Manual setting of window height. Default is NA.}

\item{show.box}{Show frame around the plot . Default is TRUE.}

\item{show.counter.border}{Percentile as limit for the display of labels in the pie charts. Default is 0.98.
Higher counts are displayed as numbers in the neuron.}

\item{predict}{\code{data.frame} as returned by the \code{som.nn::predict} function
or a \code{data.frame} or matrix that follows the specification: 
If columns \code{x} and \code{y} exist, these are used as coordinates
for the traget neuron; otherwise the first two columns are used.
Default: NULL.}

\item{add}{\code{logical}; if TRUE, points are plotted on an existing plot. This can be used to 
stepwise plot
points of different classes with different colours.}

\item{pch.col}{Colour of the markers for predicted samples.}

\item{pch}{Symbol of the markers for predicted samples.}

\item{...}{More parameters as well as general 
plot parameters are allowed; see \code{\link{par}}.}
}
\description{
Creates a plot of the hexagonal som in the model of type \code{SOMnn}.
}
\details{
In addition to the required parameters, many options can be 
specified to plot predicted samples and to modify colours, legend and scaling.
}
\examples{
## get example data and add class labels:
data(iris)
species <- iris$Species

## train with default radius = diagonal / 2:
som <- som.nn.train(iris, class.col = "Species", kernel = "kohonen",
                    xdim = 15, ydim = 9, alpha = 0.2, len = 1000, 
                    norm = TRUE, toroidal = FALSE)


## continue training with different alpha and radius;
som <- som.nn.continue(som, iris, alpha = 0.02, len=1000, radius = 5)
som <- som.nn.continue(som, iris, alpha = 0.02, len=1000, radius = 2)

## predict some samples:
unk <- iris[,!(names(iris) \%in\% "Species")]

setosa <- unk[species=="setosa",]
setosa <- setosa[sample(nrow(setosa), 20),]

versicolor <- unk[species=="versicolor",]
versicolor <- versicolor[sample(nrow(versicolor), 20),]

virginica <- unk[species=="virginica",]
virginica <- virginica[sample(nrow(virginica), 20),]

p <- predict(som, unk)
head(p)

## plot:
plot(som)
dev.off()
plot(som, predict = som@predict(setosa))
plot(som, predict = som@predict(versicolor), add = TRUE, pch.col = "magenta", pch = 17)
plot(som, predict = som@predict(virginica), add = TRUE, pch.col = "white", pch = 8)

}

