% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{Dataset.query}
\alias{Dataset.query}
\title{Dataset.query}
\usage{
Dataset.query(
  id,
  paginate = FALSE,
  use_field_titles = TRUE,
  env = solvebio:::.solveEnv,
  ...
)
}
\arguments{
\item{id}{The ID of a SolveBio dataset, or a Dataset object.}

\item{paginate}{When set to TRUE, retrieves all records (memory permitting).}

\item{use_field_titles}{(optional) Use field title instead of field name for query.}

\item{env}{(optional) Custom client environment.}

\item{...}{(optional) Additional query parameters (e.g. filters, limit, offset).}
}
\description{
Queries a SolveBio dataset and returns an R data frame containing all records.
Returns a single page of results otherwise (default).
}
\examples{
\dontrun{
Dataset.query("12345678790", paginate=TRUE)
}

}
\references{
\url{https://docs.solvebio.com/}
}
