% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDA-spatial.R
\name{processSDA_WKT}
\alias{processSDA_WKT}
\title{Post-process WKT returned from SDA.}
\usage{
processSDA_WKT(d, g = "geom", p4s = "+proj=longlat +datum=WGS84")
}
\arguments{
\item{d}{\code{data.frame} returned by \code{SDA_query}, containing WKT
representation of geometry}

\item{g}{name of column in \code{d} containing WKT geometry}

\item{p4s}{PROJ4 CRS definition, typically GCS WGS84}
}
\value{
A \code{Spatial*} object.
}
\description{
This is a helper function, commonly used with \code{SDA_query} to extract
WKT (well-known text) representation of geometry to an sp-class object.
}
\details{
The SDA website can be found at \url{https://sdmdataaccess.nrcs.usda.gov}.
See the \href{http://ncss-tech.github.io/AQP/soilDB/SDA-tutorial.html}{SDA Tutorial} for detailed examples.

The SDA website can be found at \url{https://sdmdataaccess.nrcs.usda.gov}. See the \href{http://ncss-tech.github.io/AQP/soilDB/SDA-tutorial.html}{SDA Tutorial} for detailed examples.
}
\note{
This function requires the \code{httr}, \code{jsonlite}, \code{XML} ,  and \code{sf} packages.

This function requires the \code{httr}, \code{jsonlite}, \code{XML},
and \code{rgeos} packages.
}
\author{
D.E. Beaudette

D.E. Beaudette
}
