% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_head.r
\name{doc_head}
\alias{doc_head}
\title{Get header info for a document}
\usage{
doc_head(cushion, dbname, docid, ...)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{(character) Database name. Required.}

\item{docid}{(character) Document ID. Required.}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Get header info for a document
}
\examples{
\dontrun{
(x <- Cushion$new())

# create a database
if ("sofadb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="sofadb"))
}
db_create(x, dbname='sofadb')

# create a document
doc1 <- '{"name": "drink", "beer": "IPA", "score": 5}'
doc_create(x, dbname="sofadb", doc1, docid="abeer")

# run doc_head
doc_head(x, dbname="sofadb", docid="abeer")
doc_head(x, dbname="sofadb", docid="abeer", as='json')
}
}
