% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.r
\docType{data}
\name{moschidis}
\alias{moschidis}
\title{Moschidis example}
\description{
The example dataset used by Odysseas E. Moschidis (2009):
}
\examples{
# The moschidis example
data(moschidis)
active    <- moschidis[, c("E1","E2", "E3")]
id        <- moschidis[, c("ID")]
result    <- soc.mca(active, identifier = id, Moschidis = FALSE)

# Compare output to Moschidis (2009, p. 85)
result$inertia_full
# In the analysis of the 'real' data the modality
#'E1: 1' with a low mass (fr/Q) has a very high contribution to the fourth axis
result$ctr.mod[, 4]

# Using the transformed model suggested by Moschidis (2009) that takes into
# account the number of modalities per question in order to balance the
# contribution of the modalities
result_trans    <- soc.mca(active, identifier = id, Moschidis = TRUE)
result_trans$inertia_full
result_trans$ctr.mod[, 4]
}
\references{
Moschidis, Odysseas E. “A Different Approach to Multiple
  Correspondence Analysis (MCA) than That of Specific MCA.” Mathématiques et
  Sciences Humaines / Mathematics and Social Sciences 47, no. 186 (October
  15, 2009): 77–88. https://doi.org/10.4000/msh.11091.
}
\author{
Odysseas E. Moschidis
}
\keyword{data}
