% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk.R
\name{sk_validate}
\alias{sk_validate}
\title{Check compatibility of entries in a sk grid object, and fill in any missing ones}
\usage{
sk_validate(g, res_tol = 1e-06)
}
\arguments{
\item{g}{a "sk" object or a list accepted by \code{sk_make}}

\item{res_tol}{positive numeric, tolerance validating resolution (see details)}
}
\value{
a validated "sk" object
}
\description{
This constructs the object and fills missing entries. It then does some sanity checks
and computes the index of NA points (in list entry \code{is_obs}).
}
\details{
The function removes/introduces \code{idx_grid} depending on whether \code{gval} is a vector
(single-layer case) or a matrix (usually a multi-layer case). If \code{idx_grid} is missing
and \code{gval} is a matrix, it is assumed to contain all grid-points (including NAs)

The function also assigns dimension names in the order 'y', 'x' (unless otherwise
specified) for \code{gdim}, \code{gres}, and \code{gyx}.

\code{res_tol} is used to check if the resolution \code{gres} is consistent with the spacing
of the grid lines. Only the spacing of the first two lines is computed - if the
relative error along either dimensions is greater \code{res_tol}, the function throws
an error.
}
\examples{

sk_validate(list(gdim=10, gres=0.5))
sk_validate(list(gval=stats::rnorm(10^2), gdim=10, gres=0.5))
}
\keyword{internal}
