\name{dmst}
\alias{dmst}
\alias{pmst}
\alias{rmst}
\title{
Multivariate skew-\eqn{t} distribution
}
\description{
Probability density function, distribution function and random number 
generation for the multivariate skew-\eqn{t} (MST) distribution.
}
\usage{
dmst(x, xi=rep(0,length(alpha)), Omega, alpha, df=Inf, dp = NULL, log=FALSE)
pmst(x, xi=rep(0,length(alpha)), Omega, alpha, df=Inf, dp = NULL, ...)
rmst(n=1, xi=rep(0,length(alpha)), Omega, alpha, df=Inf, dp = NULL)
}

\arguments{
\item{x}{
for \code{dmst}, this is either a vector of length \code{d},
where \code{d=length(alpha)}, or a matrix with \code{d} columns, 
giving  the coordinates of the point(s) where the density must be 
avaluated; for \code{pmst}, only a vector of length \code{d} is allowed.
}
\item{xi}{
a numeric vector of lenght \code{d}, or a matrix with \code{d} columns,
representing the location parameter of the distribution; see Background.
If \code{xi} is a matrix, its dimensions must agree with those of \code{x}.
}
\item{Omega}{
a symmetric positive-definite matrix of dimension \code{(d,d)}; see Background.
}
\item{alpha}{
a numeric vector which regulates the shape of the density; see Background
}
\item{df}{
degrees of freedom (scalar); default is \code{df=Inf} which corresponds 
to the multivariate skew-normal distribution.
}
\item{dp}{
a list with three elements named \code{xi}, \code{Omega}, \code{alpha}
and \code{df}, containing quantities as described above. 
If \code{dp} is specified, this overrides the individual parameter 
specification. 
}
\item{n}{
a numeric value which represents the number of random vectors
to be drawn.
}
\item{log}{ 
logical (default value: \code{FALSE}); if TRUE, log-densities are returned.
}
\item{...}{
additional parameters passed to \code{pmt}
}}
\value{
A vector of density values (\code{dmst}) or a single probability 
(\code{pmst}) or a matrix of random  points (\code{rmst}).
}
\details{Typical usages are
\preformatted{%
dmst(x, xi=rep(0,length(alpha)), Omega, alpha, df=Inf, log=FALSE)
dmst(x, dp=, log=FALSE)
pmst(x, xi=rep(0,length(alpha)), Omega, alpha, df=Inf, ...)
pmst(x, dp=, ...)
rmst(n=1, xi=rep(0,length(alpha)), Omega, alpha, df=Inf)
rmst(n=1, dp=)
}

The positive-definiteness of \code{Omega} is not tested for efficiency
reasons. Function \code{pmst} requires \code{pmt} from package \code{mnormt};
the accuracy of its computation can be controlled via use of \code{...}
}

\section{Background}{
The family of multivariate skew-\eqn{t} distributions is an extension of the 
multivariate Student's \eqn{t} family, via the introduction of a \code{shape} 
parameter which regulates skewness; when \code{shape=0}, the skew-\eqn{t}
distribution reduces to the usual \eqn{t} distribution. 
When \code{df=Inf} the distribution reduces to the multivariate skew-normal 
one; see \code{dmsn}. Notice that the location vector \code{xi}
does not represent the mean vector of the distribution (which in fact
may not even exist if \code{df <= 1}), and similarly
\code{Omega} is not \emph{the} covariance matrix of the distribution,
although it is \emph{a} covariance matrix. 
For additional information, see the reference below.
}

\references{
  Azzalini, A. and Capitanio, A. (2003).
  Distributions generated by perturbation of symmetry 
  with emphasis on a multivariate skew \emph{t} distribution.
  \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.
}
\seealso{
\code{\link{dst}},  \code{\link{dmsn}}, \code{\link[mnormt]{dmt}}
}
\examples{
x <- seq(-4,4,length=15)
xi <- c(0.5, -1)
Omega <- diag(2)
Omega[2,1] <- Omega[1,2] <- 0.5
alpha <- c(2,2)
pdf <- dmst(cbind(x,2*x-1), xi, Omega, alpha, df=5)
rnd <- rmst(10,  xi, Omega, alpha, 6)
p1 <- pmst(c(2,1), xi, Omega, alpha, df=5)
p2 <- pmst(c(2,1), xi, Omega, alpha, df=5, abseps=1e-12, maxpts=10000)
}
\keyword{distribution}
\keyword{multivariate}

