% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R, R/smvr.R
\name{parse_semver}
\alias{parse_semver}
\alias{smvr}
\title{A vector representing versions following Semantic Versioning}
\usage{
parse_semver(x)

smvr(major = integer(), minor = 0L, patch = 0L, pre_release = "", build = "")
}
\arguments{
\item{x}{A character vector representing semantic versions.
Each version should follow the
\href{https://semver.org/}{Semantic Versioning Specification}.
Partial matches are not allowed (e.g., \code{"1.0"} is not valid).}

\item{major, minor, patch}{Non-negative integers representing
the major, minor, and patch version components.
The default values for \code{minor} and \code{patch} are \code{0}.}

\item{pre_release}{Something that can be cast to a \link{pre_release_ids} vector.
This represents pre-release identifiers, which can be empty (\code{""})
meaning non pre-release.}

\item{build}{Optional build metadata character vector.
Should have the pattern \verb{^[a-zA-Z0-9-]+} and can contain
multiple components separated by dots (\code{"."}).
This can be empty (\code{""}) meaning no build metadata.}
}
\value{
A \link{smvr} class vector.
}
\description{
The \code{smvr} class represents versions that follow the
\href{https://semver.org/}{Semantic Versioning Specification (SemVer)}.
\itemize{
\item \code{\link[=smvr]{smvr()}} is a constructor for creating \code{smvr} objects
from each component.
\item \code{\link[=parse_semver]{parse_semver()}} parses a character vector into \code{smvr} objects.
}
}
\details{
Build metadata is not used for ordering, but the \code{==} and \code{!=} operators
check it and exactly same build metadata is required for equality.
The other operators (\code{<}, \code{<=}, \code{>}, \code{>=}) ignore build metadata.
}
\examples{
# SemVer versions from components
smvr(4, 1:5)

# Parse SemVer versions from character
parse_semver(c("1.0.0-alpha", "1.0.0-beta+exp.sha.5114f85"))

v <- parse_semver(c(
  "1.0.0",
  "1.0.0-alpha",
  "1.0.0-beta",
  "1.0.0-rc.1",
  "1.0.0-rc.2",
  NA
))
v

# Sorting
vctrs::vec_sort(v)

# Works with base R vectors.
v[v >= "1.0.0-rc.2"]

# Partial version components are treated as NA
suppressWarnings(parse_semver("1.5"))

# The numeric_version class supports versions with
# less than 3 components, and can be cast to smvr.
numeric_version("1.5") |>
  vctrs::vec_cast(smvr())
}
