% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals_reest}
\alias{residuals_reest}
\alias{residuals_reest.glmsmurf}
\alias{resid_reest}
\alias{resid_reest.glmsmurf}
\title{Residuals of Re-estimated Model}
\usage{
residuals_reest(object, ...)

\method{residuals_reest}{glmsmurf}(object, type = c("deviance",
  "pearson", "working", "response", "partial"), ...)

resid_reest(object, ...)

\method{resid_reest}{glmsmurf}(object, type = c("deviance", "pearson",
  "working", "response", "partial"), ...)
}
\arguments{
\item{object}{An object for which the extraction of model residuals is meaningful. 
E.g. an object of class '\code{\link[=glmsmurf-class]{glmsmurf}}', typically the result of a call to \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}}.}

\item{...}{Additional arguments which are currently ignored.}

\item{type}{Type of residuals that should be returned. One of \code{"deviance"} (default), 
\code{"pearson"}, \code{"working"}, \code{"response"} or \code{"partial"}.}
}
\value{
A vector containing the residuals of the re-estimated model in \code{object}
        when they are available, or, otherwise, the residuals of the estimated model in \code{object} with a warning.
}
\description{
Function to extract the residuals of the re-estimated model. 
             \code{resid_reest} is an \emph{alias} for it.
}
\details{
See \code{\link[stats]{glm.summaries}} for an overview of the different types of residuals.
}
\examples{
## See example(glmsmurf) for examples
 
}
\seealso{
\code{\link{residuals.glmsmurf}}, \code{\link{residuals}}, \code{\link[stats]{glm.summaries}}, \code{\link{glmsmurf-class}}
}
