% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_add_polygon.R
\name{sm_add_polygon}
\alias{sm_add_polygon}
\title{Adding a polygon patch on the combined figure}
\usage{
sm_add_polygon(
  combined_plot,
  x,
  y,
  fill = "gray80",
  color = "black",
  linewidth = 0.5,
  ...
)
}
\arguments{
\item{combined_plot}{Combined figure, an output from sm_put_together().}

\item{x}{A vector containing x coordinates from each point of the polygon.
The first element of x is matched to the firt element of y. Values from 0 to 1,
where 0.5 is the origin.}

\item{y}{A vector containing y coordinates from each point of the polygon.
The first element of x is matched to the firt element of y. Values from 0 to 1,
where 0.5 is the origin.}

\item{fill}{Fill color for the rectangle to be used}

\item{color}{Border line of the rectangle}

\item{linewidth}{Linewidth of border of the rectangle}

\item{...}{Other parameters to be used in annotate() from ggplot2.}
}
\value{
Prints a patch of rectangle onto a combined plot.
}
\description{
Areas captured by the coorinates of x and y will be filled.
The lengths of x and y have no limitations as long as their
lengths are matched.
}
\examples{
library(smplot2)
library(ggplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white',
            size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
 geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
 sm_hvgrid() -> p2

combined_fig <- sm_put_together(list(p1,p2), ncol=2,nrow=1)
sm_add_polygon(combined_fig, x = c(.2,.8,.8), y = c(.2,.8,.2))

}
