% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous.R
\name{continuous}
\alias{continuous}
\title{Univariate Continuous Distributions: p.d.f and c.d.f.}
\usage{
continuous(distn, var_range = NULL, params = list(),
  param_step = list(), param_range = list(), p_vec = NULL,
  smallest = 0.01, plot_par = list(), panel_plot = TRUE,
  hscale = NA, vscale = hscale, ...)
}
\arguments{
\item{distn}{Either a character string or a function to choose the
  continuous random variable.

  Strings \code{"beta"}, \code{"cauchy"}, \code{"chisq"}
  \code{"chi-squared"}, \code{"exponential"}, \code{"f"}, \code{"gamma"},
  \code{"gev"}, \code{"gp"}, \code{"lognormal"}, \code{"log-normal"},
  \code{"normal"}, \code{"t"}, \code{"uniform"} and \code{"weibull"} are
  recognised, case being ignored.  The relevant distributional functions
  \code{dxxx} and \code{pxxx} in the \code{\link[stats]{stats-package}}
  are used.  The abbreviations \code{xxx} are also recognised.
  The \code{"gev"} and \code{"gp"} cases use the
  \code{\link[revdbayes]{gev}} and \code{\link[revdbayes]{gp}}
  distributional functions in the \code{\link[revdbayes]{revdbayes}}
  package.
  If \code{distn = "gamma"} then the \code{(shape, rate)}
  parameterisation is used, unless a value for \code{scale} is provided
  via the argument \code{params} when the \code{(shape, scale)}
  parameterisation is used.

  Valid functions are set up like a standard distributional function
  \code{dxxx}, with first argument \code{x}, last argument \code{log}
  and with arguments to set the parameters of the distribution in between.
  See the \href{https://CRAN.R-project.org/view=Distributions}{
  CRAN task view on distributions}.

  If \code{distn} is not supplied then \code{distn = "normal"}
  is used.}

\item{var_range}{A numeric vector of length 2.  Can be used to set a fixed
range of values over which to plot the p.d.f. and c.d.f., in order better
to see the effects of changing the parameter values.
If \code{var_range} is set then it overrides \code{p_vec} (see below).}

\item{params}{A named list of initial parameter values with which to start
  the movie.  If \code{distn} is a string and a particular parameter value
  is not supplied then the following values are used.
  \code{"beta"}: \code{shape1 = 2, shape2 = 2, ncp = 0};
  \code{"cauchy"}: \code{location = 0, scale = 1};
  \code{"chi-squared"}: \code{df = 4, ncp = 0};
  \code{"exponential"}: \code{rate = 1};
  \code{"f"}: \code{df1 = 4, df2 = 8, ncp =0};
  \code{"gamma"}: \code{shape = 2, rate = 1};
  \code{"gev"}: \code{loc = 0, scale = 1, shape = 0.1};
  \code{"gp"}: \code{loc = 0, scale = 1, shape = 0.1};
  \code{"lognormal"}: \code{meanlog = 0, sdlog = 1};
  \code{"normal"}: \code{mean = 0, sd = 1};
  \code{"t"}: \code{df = 4, ncp = 0};
  \code{"uniform"}: \code{min = 0, max = 1};
  \code{"weibull"}: \code{shape = 2, scale = 1}.

  If \code{distn} is a function then \code{params} must set any required
  parameters.

  If parameter value is outside the corresponding range specified by
  \code{param_range} then it is set to the closest limit of the range.}

\item{param_step}{A named list of the amounts by which the respective
parameters in \code{params} are increased/decreased after one click of
the +/- button. If \code{distn} is a function then the default is 0.1
for all parameters.  If \code{distn} is a string then a sensible
distribution-specific default is set internally.}

\item{param_range}{A named list of the ranges over which the respective
parameters in \code{params} are allowed to vary.  Each element of the list
should be a vector of length 2: the first element gives the lower limit
of the range, the second element the upper limit.
Use \code{NA} to impose no limit.
If \code{distn} is a function then all parameters are unconstrained.}

\item{p_vec}{A numeric vector of length 2.  The p.d.f. and c.d.f. are
plotted between the 100\code{p_vec[1]}\% and 100\code{p_vec[2]}\%
quantiles of the distribution.  If \code{p_vec} is not supplied then
a sensible distribution-specific default is used.  If \code{distn} is
a function then the default is \code{p_vec = c(0.001, 0.999)}.}

\item{smallest}{A positive numeric scalar.  The smallest value to be
used for any strictly positive parameters when \code{distn} is a string.}

\item{plot_par}{A named list of graphical parameters
(see \code{link[graphics]{par}}) to be passed to
\code{\link[graphics]{plot}}.  This may be used to alter the appearance
of the plots of the p.m.f. and c.d.f.}

\item{panel_plot}{A logical parameter that determines whether the plot
is placed inside the panel (\code{TRUE}) or in the standard graphics
window (\code{FALSE}).  If the plot is to be placed inside the panel
then the tkrplot library is required.}

\item{hscale, vscale}{Numeric scalars.  Scaling parameters for the size
of the plot when \code{panel_plot = TRUE}. The default values are 1.4 on
Unix platforms and 2 on Windows platforms.}

\item{...}{Additional arguments to be passed to
\code{\link[rpanel]{rp.doublebutton}}, not including \code{panel},
\code{variable}, \code{title}, \code{step}, \code{action}, \code{initval},
\code{range}.}
}
\value{
Nothing is returned, only the animation is produced.
}
\description{
A movie to illustrate how the probability density function (p.d.f.) and
cumulative distribution function (c.d.f.) of a continuous random variable
depend on the values of its parameters.
}
\details{
The movie starts with a plot of the p.d.f. of the distribution
  for the initial values of the parameters.  Buttons
  increase (+) or decrease (-) each parameter.  There are radio buttons
  to switch the plot from the p.d.f. to the c.d.f. and back.
}
\examples{
# Normal example
continuous()
# Fix the range of values over which to plot
continuous(var_range = c(-10, 10))

# The same example, but using a user-supplied function and setting manually
# the initial parameters, parameter step size and range
continuous(distn = dnorm, params = list(mean = 0, sd = 1),
           param_step = list(mean = 1, sd = 1),
           param_range = list(sd = c(0, NA)))

# Gamma distribution. Show the use of var_range
continuous(distn = "gamma", var_range = c(0, 15))
}
\seealso{
\code{\link{movies}}: a user-friendly menu panel.

\code{\link{smovie}}: general information about smovie.
}
