### Penalized AFT models for the effect of the deciduous teeth
### on the emergence of the permanent teeth
###
### * models with T**.DMF 
###
### For dental paper
###
###
### 22/06/2004
###
### ##########################################################
#setwd("~/")
library(smoothSurv)

data <- read.table(paste("./", "tandmob2.dat", sep = ""), skip = 65, header = TRUE, 
                 as.is = c(T, F, T, T, rep(F, 3), rep(T, 149)))

  ## Subtract 5.0 from all time variables:
  ##   (i.e. time 0 in the analyzes = 5 years of age)
startage <- 5.0
data[,21:132] <- data[,21:132] - startage

  ## Teeth that I want to analyze and corresponding deciduous teeth (to take appropriate dmf score)
tooth <- paste(c(14, 15, 24, 25, 34, 35, 44, 45))
dectooth <- paste(c(54, 55, 64, 65, 74, 75, 84, 85))
n.teeth <- length(tooth)
  
  ## For illustration purposes, take only subset of data
data <- data[1:100,]

  ## Fit different models
# lambda <- exp(2:(-9))
lambda <- exp(0:(-3))       ### such values of lambda cover the optimal one for this data set

fgender <- list()
fdmf <- list()
fgender.dmf <- list()
fgenderxdmf <- list()
fsdmf <- list()
fsgenderxdmf <- list()
#load("./RenvGender")
#load("./RenvDmf")
#load("./RenvGenderDmf")
#load("./RenvGenderxDmf")
#load("./RenvSDmf")
#load("./RenvSGenderxDmf")
   
for (i in 1:n.teeth){
    dmf <- paste("T", dectooth[i], ".DMF", sep = "")                  ## name of covariate 'dmf' for a particular tooth
    start <- paste("EBEG.", tooth[i], sep = "")                       ## name of a variable with observed lower limit of emergence
    end <- paste("EEND.", tooth[i], sep = "")                         ## name of a variable with observed upper limit of emergence

    varwanna <- c("IDNR", "GENDER", "GENDERNum", dmf, start, end)     ## variables that will be needed in the analysis
    
    ## Remove obs. with a missing covariate and create a survival object
    tdata <- data[!is.na(data[[dmf]]), varwanna]
    surv <- Surv(tdata[[start]], tdata[[end]], type = "interval2")

    cat("\nTOOTH", tooth[i], ", T ~ gender","\n")
    cat("==================================================\n")
    fgender[[i]] <- smoothSurvReg(surv ~ GENDER, data = tdata, lambda = lambda, difforder = 3)
    names(fgender)[i] <- tooth[i]
#    save(list = c("fgender", "tooth", "dectooth", "n.teeth", "startage"), file = "./RenvGender")
    
    cat("\nTOOTH", tooth[i], ", T ~ dmf","\n")
    cat("==================================================\n")
    fdmf[[i]] <- smoothSurvReg(surv ~ get(dmf), data = tdata, lambda = lambda, difforder = 3)
    names(fdmf)[i] <- tooth[i]
#    save(list = c("fdmf", "tooth", "dectooth", "n.teeth", "startage"), file = "./RenvDmf")

    cat("\nTOOTH", tooth[i], ", T ~ gender + dmf","\n")
    cat("==================================================\n")
    fgender.dmf[[i]] <- smoothSurvReg(surv ~ GENDER + get(dmf), data = tdata, lambda = lambda, difforder = 3)
    names(fgender.dmf)[i] <- tooth[i]
#    save(list = c("fgender.dmf", "tooth", "dectooth", "n.teeth", "startage"), file = "./RenvGenderDmf")

    cat("\nTOOTH", tooth[i], ", T ~ gender * dmf","\n")
    cat("==================================================\n")
    fgenderxdmf[[i]] <- smoothSurvReg(surv ~ GENDER + get(dmf) + GENDER*get(dmf), data = tdata, lambda = lambda, difforder = 3)
    names(fgenderxdmf)[i] <- tooth[i]
#    save(list = c("fgenderxdmf", "tooth", "dectooth", "n.teeth", "startage"), file = "./RenvGenderxDmf")

    cat("\nTOOTH", tooth[i], ", T ~ gender * dmf, logscale ~ dmf","\n")
    cat("==========================================================\n")
    fsdmf[[i]] <- smoothSurvReg(surv ~ GENDER + get(dmf) + GENDER*get(dmf), logscale=~ get(dmf),
                                data = tdata, lambda = lambda, difforder = 3)
    names(fsdmf)[i] <- tooth[i]
#    save(list = c("fsdmf", "tooth", "dectooth", "n.teeth", "startage"), file = "./RenvSDmf")    
    
    cat("\nTOOTH", tooth[i], ", T ~ gender * dmf, logscale ~ gender * dmf","\n")
    cat("===================================================================\n")
    fsgenderxdmf[[i]] <- smoothSurvReg(surv ~ GENDER + get(dmf) + GENDER*get(dmf), logscale=~ GENDER + get(dmf) + GENDER*get(dmf),
                                       data = tdata, lambda = lambda, difforder = 3)
    names(fsgenderxdmf)[i] <- tooth[i]
#    save(list = c("fsgenderxdmf", "tooth", "dectooth", "n.teeth", "startage"), file = "./RenvSGenderxDmf")    
}    


## To see the results for one selected model
## a) with the information concerning fitted error distribution
## b) without this information
print(fsdmf[[1]], spline=TRUE)
print(fsdmf[[1]], spline=FALSE)

## Plot the fitted error distribution and compare it to three parametric distributions
plot(fsdmf[[1]], compare=TRUE, bty="n")

## Plot the fitted error distribution and show residuals
plot(fsdmf[[1]], resid=TRUE, compare=FALSE, bty="n")

## Plot the fitted error distribution and show mixture components
plot(fsdmf[[1]], components=TRUE, resid=FALSE, bty="n")

## Compute the fitted error distribution and store it in a data.frame, plot it late on by hand
ferr <- plot(fsdmf[[1]], plot=FALSE)
plot(ferr, type="l", lty=1, bty="n")

