% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simoes.R
\name{sim.oes}
\alias{sim.oes}
\title{Simulate Occurrence Part of ETS model}
\usage{
sim.oes(model = "MNN", obs = 10, nsim = 1, frequency = 1,
  occurrence = c("odds-ratio", "inverse-odds-ratio", "direct", "general"),
  bounds = c("usual", "admissible", "restricted"), randomizer = c("rlnorm",
  "rinvgauss", "rgamma", "rnorm"), persistence = NULL, phi = 1,
  initial = NULL, initialSeason = NULL, modelB = model,
  persistenceB = persistence, phiB = phi, initialB = initial,
  initialSeasonB = initialSeason, ...)
}
\arguments{
\item{model}{Type of ETS model according to [Hyndman et. al., 2008]
taxonomy. Can consist of 3 or 4 chars: \code{ANN}, \code{AAN}, \code{AAdN},
\code{AAA}, \code{AAdA}, \code{MAdM} etc. The conventional oETS model assumes
that the error term is positive, so "MZZ" models are recommended for this.
If you use additive error models, then the function will exponentiate the
obtained values before transforming them and getting the probability. This
is the type of model A.}

\item{obs}{Number of observations in each generated time series.}

\item{nsim}{Number of series to generate (number of simulations to do).}

\item{frequency}{Frequency of generated data. In cases of seasonal models
must be greater than 1.}

\item{occurrence}{Type of occurrence model. See \code{vignette("oes","smooth")}
for details.}

\item{bounds}{Type of bounds to use for persistence vector if values are
generated. \code{"usual"} - bounds from p.156 by Hyndman et. al., 2008.
\code{"restricted"} - similar to \code{"usual"} but with upper bound equal
to 0.3. \code{"admissible"} - bounds from tables 10.1 and 10.2 of Hyndman
et. al., 2008. Using first letter of the type of bounds also works. These
bounds are also used for multiplicative models, but the models are much
more restrictive, so weird results might be obtained. Be careful!}

\item{randomizer}{Type of random number generator function used for error
term. It is advised to use \code{rlnorm()} or \code{rinvgauss()} in case of
multiplicative error models. If a randomiser is used, it is advised to
specify the parameters in the ellipsis.}

\item{persistence}{Persistence vector, which includes all the smoothing
parameters. Must correspond to the chosen model. The maximum length is 3:
level, trend and seasonal smoothing parameters. If \code{NULL}, values are
generated.}

\item{phi}{Value of damping parameter. If trend is not chosen in the model,
the parameter is ignored.}

\item{initial}{Vector of initial states of level and trend. The maximum
length is 2. If \code{NULL}, values are generated.}

\item{initialSeason}{Vector of initial states for seasonal coefficients.
Should have length equal to \code{frequency} parameter. If \code{NULL},
values are generated.}

\item{modelB}{Type of model B. This is used in \code{occurrence="general"}
and \code{occurrence="inverse-odds-ratio"}.}

\item{persistenceB}{The persistence vector for the model B.}

\item{phiB}{Value of damping parameter for the model B.}

\item{initialB}{Vector of initial states of level and trend for the model B.}

\item{initialSeasonB}{Vector of initial states for seasonal coefficients for
the model B.}

\item{...}{Additional parameters passed to the chosen randomizer. All the
parameters should be passed in the order they are used in chosen randomizer.
Both model A and model B share the same parameters for the randomizer.}
}
\value{
List of the following values is returned:
\itemize{
\item \code{model} - Name of ETS model.
\item \code{modelA} - Model A, generated using \code{sim.es()} function;
\item \code{modelB} - Model B, generated using \code{sim.es()} function;
\item \code{probability} - The value of probability generated by the model;
\item \code{occurrence} - Type of occurrence used in the model;
\item \code{logLik} - Log-likelihood of the constructed model.
}
}
\description{
Function generates data using ETS with Single Source of Error as a data
generating process for the demand occurrence. As the main output it produces
probabilities of occurrence.
}
\details{
For the information about the function, see the vignette:
\code{vignette("simulate","smooth")}
}
\examples{

# This example uses rinvgauss function from statmod package.
\donttest{oETSMNNIG <- sim.oes(model="MNN",frequency=12,obs=60,
                               randomizer="rinvgauss",mean=1,dispersion=0.5)}

# A simpler example with log normal distribution
oETSMNNlogN <- sim.oes(model="MNN",frequency=12,obs=60,initial=1,
                       randomizer="rlnorm",meanlog=0,sdlog=0.1)

}
\references{
\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}
}
\seealso{
\code{\link[smooth]{oes}, \link[smooth]{sim.es}, \link[stats]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
