% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_scan_test.R
\name{seq_scan_test}
\alias{seq_scan_test}
\title{Sequential Scan Test}
\usage{
seq_scan_test(
  coords,
  cases,
  pop,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.05,
  ubpop_seq = seq(0.01, 0.5, len = 50),
  longlat = FALSE,
  cl = NULL,
  type = "poisson",
  min.cases = 0,
  simdist = "multinomial"
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop_seq}{A strictly increasing numeric vector with values between
min(pop)/sum(pop) and 1. The default is \code{seq(0.01, 0.5, len = 50)}.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}

\item{simdist}{Character string indicating the simulation
distribution. The default is \code{"multinomial"}, which
conditions on the total number of cases observed. The
other options are \code{"poisson"} and \code{"binomial"}}
}
\value{
Returns a list of \code{length(ubpop_seq)}. Each element of the
list has "pruned" set of results (as a list) for a scan test. Element of
the pruned list has the elements \code{tobs}, \code{zones}, \code{pvalue}.
}
\description{
Performs a series of sequential scan tests by ubpop. Only minimal information is returned
for each test. This is intended for internal use by the smerc package.
}
\seealso{
\code{\link{scan.test}}
}
\author{
Joshua French
}
\keyword{internal}
