% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.factor.custom}
\alias{smbinning.factor.custom}
\title{Customized Binning on Factor Variables}
\usage{
smbinning.factor.custom(df, y, x, groups)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot.}

\item{x}{A factor variable with at least 2 different values. Value \code{Inf} is not allowed.}

\item{groups}{Specifies customized groups created by the user.
Name of \code{x} must not have a dot.}
}
\value{
The command \code{smbinning.factor.custom} generates an object containing the necessary information 
and utilities for binning.
The user should save the output result so it can be used 
with \code{smbinning.plot}, \code{smbinning.sql}, and \code{smbinning.gen.factor}.
}
\description{
It gives the user the ability to combine categories and create new attributes for a given characteristic.
Once these new attribues are created in a list (called \code{groups}), the funtion generates a table for 
the uniques values of a given factor variable.
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data

# Example: Customized binning for a factor variable
# Notation: Groups between double quotes
result=smbinning.factor.custom(
  chileancredit,x="inc",
  y="fgood",
  c("'W01','W02'",        # Group 1
    "'W03','W04','W05'",  # Group 2
    "'W06','W07'",        # Group 3
    "'W08','W09','W10'")) # Group 4
result$ivtable
}
